/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.javautils.gui.print;

import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import tecgraf.javautils.gui.print.PrintSimulator;

class PagePanel
extends JPanel {
    private static final double PAPER_HEIGHT = 792.0;
    private static final double PAPER_WIDTH = 612.0;
    private static final double IMAGEABLE_AREA_HEIGHT = 706.96;
    private static final double IMAGEABLE_AREA_WIDTH = 470.27;
    private static final double IMAGEABLE_AREA_X = 70.87;
    private static final double IMAGEABLE_AREA_Y = 42.52;
    private Printable printable;
    private PageFormat pageFormat;
    private int pageIndex;
    private PrintSimulator simulator;

    public PagePanel(PrintSimulator simulator) {
        this.simulator = simulator;
        Paper paper = new Paper();
        paper.setSize(612.0, 792.0);
        paper.setImageableArea(70.87, 42.52, 470.27, 706.96);
        this.pageFormat = new PageFormat();
        this.pageFormat.setPaper(paper);
        this.pageFormat.setOrientation(1);
        this.setMaximumSize(new Dimension(612, 792));
        this.setPreferredSize(new Dimension(612, 792));
        this.setMinimumSize(new Dimension(612, 792));
        this.setBackground(Color.BLACK);
        this.setPrintable(this.printable);
        this.pageIndex = 0;
    }

    public void setPrintable(Printable printable) {
        this.printable = printable;
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        Graphics2D g2d = (Graphics2D)g;
        Paint colorBackup = g2d.getPaint();
        g2d.setPaint(Color.WHITE);
        g2d.fillRect(0, 0, 612, 792);
        g2d.setPaint(colorBackup);
        try {
            int result = this.printable.print(g, this.pageFormat, this.pageIndex);
            if (result == 1) {
                this.simulator.noSuchPageCallback();
            }
        }
        catch (PrinterException e) {
            Container parentFrame = this.getParent().getParent().getParent().getParent().getParent().getParent();
            JOptionPane.showMessageDialog(parentFrame, e.getMessage() + "\nConsulte a sa\u00edda do console para ver a pilha.", "PrintSimulator - Erro ao visualizar impress\u00e3o", 0);
            e.printStackTrace();
        }
    }

    public void nextPage() {
        ++this.pageIndex;
        this.repaint();
    }
}

