package tecgraf.javautils.gui.table;

import java.awt.Component;

import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;

/**
 * Exemplo de uso da classe {@link GroupableTableHeader}.
 * 
 * @author Tecgraf
 */
public class GroupableTableHeaderSample {

  /**
   * Cria uma janela para exibir o componente.
   * 
   * @param args no usado.
   */
  public static void main(String[] args) {
    SwingUtilities.invokeLater(new Runnable() {

      @Override
      public void run() {
        JFrame f = new JFrame();
        f.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        f.add(createTable());
        f.pack();
        f.setVisible(true);
      }
    });

  }

  /**
   * @return tabela simples.
   */
  private static Component createTable() {
    Object[][] data = { { 23, 254, 544, 534, 988 } };
    Object[] columnNames = new String[5];

    final int CAMPINAS = 0;
    final int SAO_PAULO = 1;
    final int RIO_DE_JANEIRO = 2;
    final int NITEROI = 3;
    final int PARIS = 4;

    columnNames[CAMPINAS] = "Campinas";
    columnNames[SAO_PAULO] = "So Paulo";
    columnNames[RIO_DE_JANEIRO] = "Rio de Janeiro";
    columnNames[NITEROI] = "Niteri";
    columnNames[PARIS] = "Paris";

    TableModel model = new DefaultTableModel(data, columnNames);
    JTable table = new JTable(model);
    GroupableTableHeader tableHeader =
      new GroupableTableHeader(table.getColumnModel());

    ColumnGroup brasil = new ColumnGroup("Brasil");
    ColumnGroup rj = new ColumnGroup("SP");
    ColumnGroup sp = new ColumnGroup("RJ");
    ColumnGroup frana = new ColumnGroup("Frana");
    ColumnGroup ileDeFrance = new ColumnGroup("Ile-de-France");
    brasil.add(sp);
    sp.add(table.getColumnModel().getColumn(CAMPINAS));
    sp.add(table.getColumnModel().getColumn(SAO_PAULO));
    rj.add(table.getColumnModel().getColumn(RIO_DE_JANEIRO));
    rj.add(table.getColumnModel().getColumn(NITEROI));
    ileDeFrance.add(table.getColumnModel().getColumn(PARIS));
    brasil.add(rj);
    frana.add(ileDeFrance);

    tableHeader.addColumnGroup(brasil);
    tableHeader.addColumnGroup(frana);
    table.setTableHeader(tableHeader);

    return new JScrollPane(table);
  }
}
