/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.javautils.gui.print;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterJob;
import tecgraf.javautils.gui.print.TextTool;

public class TextToolSample {
    public static void main(String[] arg) throws Exception {
        PrinterJob job = PrinterJob.getPrinterJob();
        job.setPrintable(new Printable(){
            int pos = 0;
            int lastPos = 0;
            int lastPage = 0;
            boolean finished = false;

            @Override
            public int print(Graphics g, PageFormat format, int page) {
                if (this.finished && page > this.lastPage) {
                    return 1;
                }
                Graphics2D g2d = (Graphics2D)g;
                g2d.setPaint(Color.black);
                g2d.setFont(new Font("SansSerif", 0, 8));
                float df = 20.0f;
                float x = (float)format.getImageableX() + df;
                float y = (float)format.getImageableY() + df;
                float w = (float)format.getImageableWidth() - df;
                float h = (float)format.getImageableHeight() - df;
                float dx = w / 4.0f;
                Point2D.Float pt = new Point2D.Float(x + dx, y);
                Rectangle2D.Float rect = new Rectangle2D.Float();
                Ellipse2D.Float dot = new Ellipse2D.Float();
                TextTool tt = new TextTool();
                String[] refs = new String[]{"n ", "s ", "e", "w", "ne", "nw", "se", "sw", "c"};
                String[] aligns = new String[]{"left", "center", "right"};
                for (int i = 0; i < refs.length; ++i) {
                    for (int j = 0; j < aligns.length; ++j) {
                        String text = "Refer\u00eancia: " + refs[i] + "\nAlinhamento: " + aligns[j];
                        tt.getBBox(g2d, text, pt, refs[i], rect);
                        if (rect.getMinY() < ((Point2D)pt).getY()) {
                            ((Point2D)pt).setLocation(((Point2D)pt).getX(), ((Point2D)pt).getY() + ((Point2D)pt).getY() - rect.getMinY());
                            tt.getBBox(g2d, text, pt, refs[i], rect);
                        }
                        if (rect.getMaxY() > (double)(y + h)) {
                            ((Point2D)pt).setLocation(((Point2D)pt).getX() + (double)dx, y);
                            tt.getBBox(g2d, text, pt, refs[i], rect);
                        }
                        g2d.draw(rect);
                        ((RectangularShape)dot).setFrame(((Point2D)pt).getX() - 1.0, ((Point2D)pt).getY() - 1.0, 3.0, 3.0);
                        g2d.fill(dot);
                        tt.draw(g2d, text, pt, refs[i], aligns[j]);
                        ((Point2D)pt).setLocation(((Point2D)pt).getX(), rect.getMaxY() + 5.0);
                    }
                    ((Point2D)pt).setLocation(((Point2D)pt).getX(), ((Point2D)pt).getY() + (double)df);
                }
                String text = "Isso \u00e9 um texto\t\t que deve ser*\nescrito em v\u00e1rias\t linhas.*\nTodas as linhas\t terminam*\ncom um '*' para\t\t que seja poss\u00edvel*\nver se as quebras\t foram feitas*\ne/ou se houve perda\t de texto*\nnas linhas muito\t longas.*\nEssa linha, por exemplo \u00e9 muito longa e n\u00e3o deve caber na caixa fornecida... (mas termina com um * ainda assim!)*\n*\nA linha anterior s\u00f3 tem o *.*\nAgora repete tudo de novo:*\nIsso \u00e9 um texto que deve ser*\nescrito em v\u00e1rias linhas.*\nTodas as linhas terminam*\ncom um '*' para que seja poss\u00edvel*\nver se as quebras foram feitas*\ne/ou se houve perda de texto*\nnas linhas muito longas.*\nEssa linha, por exemplo \u00e9 muito longa e n\u00e3o deve caber na caixa fornecida... (mas termina com um * ainda assim!)*\n*\nA linha anterior s\u00f3 tem o *.*\n";
                ((Rectangle2D)rect).setRect(rect.getMaxX() + (double)df, rect.getMaxY() + (double)df, Math.min((double)(x + w) - rect.getMaxX() - (double)df, 200.0), Math.min((double)(y + h) - rect.getMaxY() - (double)df, 100.0));
                g2d.draw(rect);
                if (page > this.lastPage) {
                    this.lastPage = page;
                    this.lastPos = this.pos;
                }
                this.pos = tt.draw(g2d, text, this.lastPos, rect, "word", "left");
                this.finished = this.pos == text.length();
                return 0;
            }
        });
        job.printDialog();
        job.print();
        System.out.println("Digite <enter> para terminar.");
        System.in.read();
        System.exit(0);
    }
}

