/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.javautils.gui.selector;

import java.awt.Component;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JFrame;
import tecgraf.javautils.gui.selector.ContainerSelection;
import tecgraf.javautils.gui.table.DefaultObjectTableProvider;

public class ContainerSelectionSample {
    public static void main(String[] args) {
        MyProvider provider = new MyProvider();
        ContainerSelection container = new ContainerSelection(provider);
        ArrayList<TestObject> availableElements = new ArrayList<TestObject>();
        Method[] methods = container.getClass().getDeclaredMethods();
        for (int i = 0; i < methods.length; ++i) {
            TestObject obj = new TestObject();
            obj.id = i;
            obj.name = methods[i].getName();
            availableElements.add(obj);
        }
        container.loadItems(availableElements);
        JFrame frame = new JFrame("Teste");
        frame.setDefaultCloseOperation(3);
        frame.getContentPane().add((Component)container.getPanel(), "Center");
        frame.pack();
        frame.setVisible(true);
        List availables = container.getSelectedItems();
        for (TestObject available : availables) {
            System.out.println("id: " + available.id + " | name: " + available.name);
        }
        List selecteds = container.getSelectedItems();
        for (TestObject selected : selecteds) {
            System.out.println("id: " + selected.id + " | name: " + selected.name);
        }
    }

    private static class MyProvider
    extends DefaultObjectTableProvider {
        private MyProvider() {
        }

        @Override
        public String[] getColumnNames() {
            return new String[]{"Identificador", "Nome"};
        }

        @Override
        public Class<?>[] getColumnClasses() {
            return new Class[]{Integer.class, String.class};
        }

        public Object[] getCellValues(Object row) {
            return new Object[]{((TestObject)row).id, ((TestObject)row).name};
        }
    }

    private static class TestObject {
        Integer id;
        String name;

        private TestObject() {
        }
    }
}

