/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.javautils.gui.wizard;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import tecgraf.javautils.gui.wizard.Step;

public final class StepGroup {
    private String description;
    private Set<Step> stepSet;
    private Map<Class<? extends Step>, Step> stepMap;

    public StepGroup(String description) {
        if (description == null) {
            throw new IllegalArgumentException("A descri\u00e7\u00e3o n\u00e3o pode ser nula.");
        }
        this.stepSet = new HashSet<Step>();
        this.stepMap = new HashMap<Class<? extends Step>, Step>();
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public void add(Step step) {
        Class<?> clazz = step.getClass();
        this.stepMap.put(clazz, step);
        this.stepSet.add(step);
    }

    public Step get(Class<? extends Step> stepClass) {
        return this.stepMap.get(stepClass);
    }

    public Set<? extends Step> getAll() {
        return Collections.unmodifiableSet(this.stepSet);
    }

    public boolean contains(Step step) {
        return this.stepSet.contains(step);
    }
}

