package tecgraf.javautils.gui.print;

import java.awt.Color;
import java.awt.Font;
import java.awt.print.PageFormat;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.util.ArrayList;
import java.util.List;

import javax.swing.ImageIcon;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;

import tecgraf.javautils.gui.GUIResources;

/**
 * Exemplo de uso da classe {@link DefaultPrintableReport}.
 * 
 * @author Tecgraf/PUC-Rio
 */
public class DefaultPrintableReportSample {

  /**
   * Mtodo de teste para a classe.
   * 
   * @param args no utilizados.
   * 
   * @throws PrinterException caso ocorra alguma exceo ao preparar a impresso
   *         do relatrio.
   */
  public static void main(String[] args) throws PrinterException {
    // Criao de listas aninhadas de componentes.
    List<PrintableReportItem> page = new ArrayList<PrintableReportItem>();
    PrintableReportItemArrayList level0 = new PrintableReportItemArrayList();
    PrintableReportItemArrayList level1 = new PrintableReportItemArrayList();
    PrintableReportItemArrayList level2a = new PrintableReportItemArrayList();
    PrintableReportItemArrayList level3a = new PrintableReportItemArrayList();
    PrintableReportItemArrayList level2b = new PrintableReportItemArrayList();
    PrintableReportItemArrayList level3b = new PrintableReportItemArrayList();
    PrintableReportItemArrayList secondLine =
      new PrintableReportItemArrayList();
    PrintableReportItemArrayList thirdLine = new PrintableReportItemArrayList();

    // Construo layout
    //    page.add(level0);
    //    page.add(secondLine);
    page.add(thirdLine);

    // Level 0 (Primeira linha, dividida em colunas)
    level0.add(new PrintableText("Holding back the years",
      PrintableUI.PRINT_FONT));
    level0.add(new PrintableText("Hello world!", PrintableUI.TITLE_PRINT_FONT));
    level0.add(level1);
    level0.add(new PrintableText("Leitura", PrintableUI.PRINT_FONT));

    Font NORMAL_FONT = new Font("SansSerif", Font.PLAIN, 12);
    Color LIGHT_GREEN_COLOR = new Color(204, 255, 153);
    List<TableColumnGroup> colGroups = new ArrayList<TableColumnGroup>();
    colGroups.add(new TableColumnGroup(
      "Relao EC/EO praticada no perodo (%)", 0, 2));
    Object[][] data = { { 045.56, 123.99, GUIResources.BACK_ICON } };
    Object[] colNames = { "Mdia", "Max", "Min" };
    TableModel model = new DefaultTableModel(data, colNames);
    PrintableTable table =
      new DefaultPrintableTable(model, NORMAL_FONT, false, false, colGroups);
    table.setCellFont(0, 0, 1, 1, NORMAL_FONT.deriveFont(Font.BOLD, 15));
    table.setColumnAlignment(new int[] { 0, 1, 2 }, PrintableTable.CENTER);
    table.setRowColor(0, 0, 0, LIGHT_GREEN_COLOR);
    table.setRowColor(1, 0, 2, LIGHT_GREEN_COLOR);
    table.setLineWidth(1f);
    level0.add(table);

    // Level 1 (Coluna dividida em trs linhas)
    level1.add(level2a);
    level1.add(new PrintableText("Aula curso longa", PrintableUI.PRINT_FONT));
    level1.add(level2b);

    // Level 2a (Linha dividida em duas colunas)
    level2a.add(new PrintableText("Prmio", PrintableUI.PRINT_FONT));
    level2a.add(new PrintableSeparator(PrintableUI.PRINT_FONT));
    level2a.add(level3a);

    // Level 3a (Coluna dividida em duas linhas)
    level3a.add(new PrintableText("Pasto", PrintableUI.PRINT_FONT));
    level3a.add(new PrintableText("Gula", PrintableUI.PRINT_FONT));

    // Level 2b (Linha dividida em duas colunas)
    level2b.add(new PrintableText("Trem", PrintableUI.PRINT_FONT));
    level2b.add(level3b);

    // Level 3b (Coluna dividida em trs linhas)
    level3b.add(new PrintableText("Suite", PrintableUI.PRINT_FONT));
    level3b.add(new PrintableImage(new ImageIcon("bolinha.GIF"),
      PrintableImage.HorizontalAlignment.LEFT));
    level3b.add(new PrintableText("Maskara", PrintableUI.PRINT_FONT));
    level3b.add(table);

    // Linha 2
    secondLine.add(new PrintableText("Holding back the years",
      PrintableUI.PRINT_FONT));
    secondLine.add(new PrintableText("Hello world!",
      PrintableUI.TITLE_PRINT_FONT));
    secondLine.add(new PrintableText(
      "Minha premissa  de que esta linha seja longa...",
      PrintableUI.PRINT_FONT));

    // Linha 3
    thirdLine.add(new PrintableText(
      "Holding back the years at o fim dos tempos", PrintableUI.PRINT_FONT));
    thirdLine.add(table);
    //    thirdLine.add(new PrintableText(
    //      "Minha premissa  de que esta linha seja longa...",
    //      PrintableUI.PRINT_FONT));

    // Relatrio
    PrintableReport report = new DefaultPrintableReport(page);
    report.setOrientation(PageFormat.PORTRAIT);
    PrinterJob job = PrinterJob.getPrinterJob();
    job.setPageable(report);
    if (job.printDialog()) {
      job.print();
    }
  }
}
