package tecgraf.javautils.gui;

import java.util.ResourceBundle;

/**
 * Interface que disponibiliza as propriedades de configurao da biblioteca.
 * Todas as propriedades so lidas no carregamento da classe e disponibilizadas
 * atravs de constantes pblicas. Essa estratgia foi adotada para agilizar o
 * acesso a essas propriedades, partindo-se da premissa de que elas so pouco
 * mutveis. Em consequncia, as propriedades no sero recarregadas enquanto a
 * JVM no for reiniciada.
 * 
 * @author Leonardo Barros
 */
public interface Config {
  /** Nome de base para encontrar o arquivo de propriedades de configurao */
  String CONFIG_BASE_NAME = "javautils_config";

  /** Objeto que carrega todas as propriedades a partir do arquivo */
  ResourceBundle props = ResourceBundle.getBundle(CONFIG_BASE_NAME);

  /** Diretrio de recursos */
  String IMAGES_DIRECTORY = props.getString("images.dir");

  /** Diretrio de recursos para <code>JButtons</code> */
  String BUTTON_DIRECTORY = props.getString("button.dir");

  /** Diretrio de recursos para <code>JLabels</code> */
  String LABEL_DIRECTORY = props.getString("label.dir");

  /** Diretrio de recursos para <code>StatusBar</code> */
  String STATUS_DIRECTORY = props.getString("status.dir");

  /** Diretrio de recursos para tabelas */
  String TABLE_DIRECTORY = props.getString("table.dir");

  /** Nome do cone de limpeza em boto */
  String BUTTON_CLEAR_ICON_NAME = props.getString("button.clear.icon.name");

  /**
   * Nome do cone de composio de mail/notificao em boto (padro adaptado)
   */
  String BUTTON_MAIL_ICON_NAME = props.getString("button.mail.icon.name");

  /** Nome do cone padro de ajuda em boto */
  String BUTTON_HELP_ICON_NAME = props.getString("button.help.icon.name");

  /** Nome do cone padro de monitorao em boto */
  String BUTTON_MONITOR_ICON_NAME = props.getString("button.monitor.icon.name");

  /** Nome do cone padro de ajuda em boto */
  String BUTTON_FILE_CHOOSER_ICON_NAME = props
    .getString("button.filechooser.icon.name");

  /** Nome do cone padro de preview. */
  String BUTTON_PREVIEW_ICON_NAME = props.getString("button.preview.icon.name");

  /** Nome do cone padro de ajuda em boto */
  String BUTTON_DETAIL_ICON_NAME = props.getString("button.detail.icon.name");

  /**
   * Nome do cone para a seta lateral usada em botes do tipo
   * <code>MenuButton</code>.
   */
  String BUTTON_ARROW_RIGHT_ICON_NAME = props
    .getString("button.arrowright.icon.name");

  /**
   * Nome do cone para a seta para baixo usada em botes do tipo
   * <code>MenuButton</code>.
   */
  String BUTTON_ARROW_DOWN_ICON_NAME = props
    .getString("button.arrowdown.icon.name");

  /**
   * Nome do cone para a seta para a esquerda usada em botes do tipo
   * <code>MenuButton</code>.
   */
  String BUTTON_ARROW_LEFT_ICON_NAME = props
    .getString("button.arrowleft.icon.name");

  /**
   * Nome do cone para a seta para cima usada em botes do tipo
   * <code>MenuButton</code>.
   */
  String BUTTON_ARROW_UP_ICON_NAME = props
    .getString("button.arrowup.icon.name");

  /**
   * Nome do cone padro de "warning" em label ("large") utilizado tipicamente
   * em painis de "warning"
   */
  String LABEL_WARNING_LARGE_ICON_NAME = props
    .getString("label.warning.large.icon");

  /**
   * Nome do cone padro de "question" em label ("large") utilizado tipicamente
   * em painis de "question"
   */
  String LABEL_QUESTION_LARGE_ICON_NAME = props
    .getString("label.question.large.icon");

  /** Nome do cone de erro para <code>JLabel</code> */
  String LABEL_ERROR_LARGE_ICON_NAME = props
    .getString("label.error.large.icon.name");

  /** Nome do cone de erro para <code>JLabel</code> */
  String LABEL_ERROR_ICON_NAME = props.getString("label.error.icon.name");

  /** Nome do cone de info para <code>StatusBar</code> */
  String STATUS_INFO_ICON_NAME = props.getString("status.info.icon.name");

  /** Nome do cone de erro para <code>StatusBar</code> */
  String STATUS_ERROR_ICON_NAME = props.getString("status.error.icon.name");

  /** Nome do cone de warning para <code>StatusBar</code> */
  String STATUS_WARNING_ICON_NAME = props.getString("status.warning.icon.name");

  /**
   * Define a margem entre a borda de um boto de imagem e a borda do seu cone
   * interno.
   */
  int IMAGE_BUTTON_MARGIN = Integer.parseInt(props
    .getString("image.button.margin"));

  /** Diretrio de recursos para o wizard. */
  String WIZARD_DIRECTORY = props.getString("wizard.dir");

  /** Nome do cone de avano para o wizard. */
  String FORWARD_ICON_NAME = props.getString("forward.icon.name");

  /** Nome do cone de retrocesso para o wizard. */
  String BACK_ICON_NAME = props.getString("back.icon.name");

  /** Diretrio de recursos para o seletor. */
  String SELECTOR_DIRECTORY = props.getString("selector.dir");

  /** Nome do cone de adicionar todos do seletor. */
  String SELECTOR_ADDALL_ICON_NAME = props
    .getString("selector.addAll.icon.name");

  /** Nome do cone de adicionar do seletor. */
  String SELECTOR_ADD_ICON_NAME = props.getString("selector.add.icon.name");

  /** Nome do cone de remover todos do seletor. */
  String SELECTOR_REMOVEALL_ICON_NAME = props
    .getString("selector.removeAll.icon.name");

  /** Nome do cone de remover do seletor. */
  String SELECTOR_REMOVE_ICON_NAME = props
    .getString("selector.remove.icon.name");

  /** Nome do cone de restaurar default do seletor. */
  String SELECTOR_RESTORE_ICON_NAME = props
    .getString("selector.restore.icon.name");

  /** Nome do cone do calendrio em boto */
  String BUTTON_CALENDAR_ICON_NAME = props
    .getString("button.calendar.icon.name");

  /**
   * Nome do cone do boto "expandir" ("+").
   */
  String BUTTON_EXPAND_ICON_NAME = props.getString("button.expand.icon.name");

  /**
   * Nome do cone do boto "fechar" ("-").
   */
  String BUTTON_COLLAPSE_ICON_NAME = props
    .getString("button.collapse.icon.name");

  /**
   * Nome do cone do boto "expandir todos".
   */
  String BUTTON_EXPAND_ALL_ICON_NAME = props
    .getString("button.expandAll.icon.name");

  /**
   * Nome do cone do boto "fechar todos".
   */
  String BUTTON_COLLAPSE_ALL_ICON_NAME = props
    .getString("button.collapseAll.icon.name");
}
