/*
 * Created on Mar 29, 2005
 */
package tecgraf.javautils.gui;

import java.awt.Container;
import java.awt.FlowLayout;
import java.lang.reflect.Field;

import javax.swing.*;

/**
 * Ferramenta de visualizao dos cones da classe <code>GUIResources</code>.
 *
 * @author Leonardo Barros
 */
public class GUIResourcesViewer {

  /**
   * Exibe uma janela contendo vrios botes, cada um com um cone e o seu nome
   * na classe <code>GUIResources</code>.
   *
   * @param args
   * @throws Exception
   */
  public static void main(String[] args) throws Exception {
    JFrame frame = new JFrame("GUIResourcesViewer");
    frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
    Container contentPane = frame.getContentPane();
    contentPane.setLayout(new FlowLayout());
    Field[] fields = GUIResources.class.getFields();
    for (int i = 0; i < fields.length; i++) {
      if (fields[i].getType().getName().equals("javax.swing.ImageIcon")) {
        contentPane.add(makeButton(fields[i]));
      }
    }
    frame.setSize(600, 400);
    frame.setVisible(true);
  }

  /**
   * Mtodo para a construo de um boto a partir da reflexo de um campo
   * de cone.
   *
   * @param imageIconField campo refletido de cone.
   *
   * @return boto contendo o nome do campo e o cone.
   *
   * @throws Exception
   */
  private static JButton makeButton(Field imageIconField) throws Exception {
    ImageIcon icon = (ImageIcon)imageIconField.get(null);
    String fieldName = imageIconField.getName();
    JButton button = new JButton(fieldName);
    button.setIcon(icon);
    return button;
  }
}

