/*
 * Created on Mar 28, 2005
 */
package tecgraf.javautils.gui;

import java.awt.Component;

import javax.swing.JOptionPane;

import tecgraf.javautils.core.lng.LNG;
import tecgraf.javautils.core.lng.LNGKeys;

/**
 * A classe <code>StandardDialogs</code> fornece mtodos de convenincia para a
 * criao de dilogos com o usurio.
 *
 * @see StandardDialogsSample
 * 
 * @author Ana Moura e Maria Jlia Lima
 */
public class StandardDialogs {
  
  /** Opo de confirmao para o SIM */
  public static final int YES_OPTION = JOptionPane.YES_OPTION;
  /** Opo de confirmao para o NO */
  public static final int NO_OPTION = JOptionPane.NO_OPTION;
  /** Opo de confirmao para o CANCELA */
  public static final int CANCEL_OPTION = JOptionPane.CANCEL_OPTION;
  
  /**
   * Mostra um dilogo com uma informao.
   *
   * @param component O componente que solicitou o dilogo.
   * @param title o ttulo do dilogo.
   * @param msg A mensagem a ser exibida.
   */
  public static void showInfoDialog(
    Component component, String title, Object msg) {
    JOptionPane.showMessageDialog(
      component, msg, title, JOptionPane.INFORMATION_MESSAGE);
  }

  /**
   * Mostra um dilogo com uma pergunta e oferece um conjunto de botes com os
   * ttulos especificados como alternativas de resposta.
   *
   * @param component A janela principal que solicitou esse dilogo.
   * @param title O ttulo do dilogo.
   * @param question A pergunta feita pelo dilogo.
   * @param options Um array com os ttulos dos botes de opo.
   *
   * @return O ndice da opo escolhida.
   *
   * @throws IllegalArgumentException se o array for nulo ou vazio.
   */
  public static int showOptionDialog(
    Component component, String title, Object question, Object[] options) {
    if (options == null || options.length == 0) {
      throw new IllegalArgumentException("options == null");
    }
    if (options.length == 0) {
      throw new IllegalArgumentException("options.length == 0");
    }
    return JOptionPane.showOptionDialog(
      component, question, title, JOptionPane.DEFAULT_OPTION,
      JOptionPane.QUESTION_MESSAGE, null, options, options[0]);
  }

  /**
   * Mostra uma janela de dilogo com os botes "Sim", "No" e "Cancelar".
   *
   * @param window O componente pai que solicitou o dilogo.
   * @param title O ttulo do dilogo.
   * @param question A pergunta feita pelo dilogo.
   *
   * @return ndice da resposta (ver {@link JOptionPane}) .
   */
  public static int showYesNoCancelDialog(
    Component window, String title, Object question) {
    Object[] options =
      {
        LNG.get(LNGKeys.YES),
        LNG.get(LNGKeys.NO), LNG.get(LNGKeys.CANCEL)
      };
    return showOptionDialog(window, title, question, options);
  }

  /**
   * Mostra uma janela de dilogo com os botes "Sim" e "No".
   *
   * @param component O componente que solicitou o dilogo.
   * @param title O ttulo do dilogo.
   * @param question A pergunta feita pelo dilogo.
   *
   * @return o ndice da opo selecionada (ver {@link JOptionPane}).
   */
  public static int showYesNoDialog(
    final Component component, final String title, final Object question) {
    final Object[] options =
      { LNG.get(LNGKeys.YES), LNG.get(LNGKeys.NO) };
    return showOptionDialog(component, title, question, options);
  }
  
  /**
   * Mostra uma janela de dilogo com os botes "Sim", "Sim para todos", "No" e 
   * "No para todos".
   *
   * @param component O componente que solicitou o dilogo.
   * @param title O ttulo do dilogo.
   * @param question A pergunta feita pelo dilogo.
   *
   * @return o ndice da opo selecionada (ver {@link JOptionPane}).
   */
  public static int showYesNoAllDialog(
    final Component component, final String title, final Object question) {
    final Object[] options =
    { LNG.get(LNGKeys.YES),LNG.get(LNGKeys.YES_TO_ALL),
      LNG.get(LNGKeys.NO),LNG.get(LNGKeys.NO_TO_ALL)};
    return showOptionDialog(component, title, question, options);
  }

  /**
   * Mostra um dilogo de aviso de erro.
   *
   * @param component A janela principal que solicitou esse dilogo.
   * @param title O ttulo do dilogo.
   * @param msg A mensagem a ser exibida.
   */
  public static void showErrorDialog(
    Component component, String title, String msg) {
    JOptionPane.showMessageDialog(
      component, msg, title, JOptionPane.ERROR_MESSAGE);
  }

  /**
   * Mostra um dilogo de alerta (warning).
   *
   * @param component A janela principal que solicitou esse dilogo.
   * @param title O ttulo do dilogo.
   * @param msg A mensagem a ser exibida.
   */
  public static void showWarningDialog(
    Component component, String title, String msg) {
    JOptionPane.showMessageDialog(
      component, msg, title, JOptionPane.WARNING_MESSAGE);
  }
}
