package tecgraf.javautils.gui.crud.demo.view;

import javax.swing.JLabel;
import javax.swing.JTextField;

import tecgraf.javautils.gui.crud.demo.logic.Plane;
import tecgraf.javautils.gui.crud.gui.edition.RegistrationEditionPanel;
import tecgraf.javautils.gui.crud.gui.main.RegistrationMainPanel;
import tecgraf.javautils.gui.crud.utils.TextListeners;

/**
 * Painel.
 *
 * @author Tecgraf
 */
public class PlaneEditPanel extends RegistrationEditionPanel<Plane, Plane> {

  /**
   * campo de texto:
   */
  final JTextField nameText = new JTextField(20);

  /**
   * campo de texto:
   */
  final JTextField lenText = new JTextField(5);

  /**
   * {@inheritDoc}
   */
  @Override
  public Plane getObjectFromIHC() {
    final double l;
    try {
      l = Double.parseDouble(lenText.getText());
    }
    catch (NumberFormatException nfe) {
      return null;
    }
    return new Plane(nameText.getText(), l);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void setObjectToIHC(Plane plane) {
    nameText.setText(plane.name);
    lenText.setText(plane.lengthMeters + "");
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void setReadOnlyIHC(boolean readOnly) {
    nameText.setEditable(!readOnly);
    lenText.setEditable(!readOnly);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void clearIHC() {
    nameText.setText(null);
    lenText.setText(null);
  }

  /**
   * Construtor
   *
   * @param mainPanel painel.
   */
  public PlaneEditPanel(RegistrationMainPanel<Plane, Plane> mainPanel) {
    super(mainPanel);
    getContainer().add(new JLabel("Nome:"));
    getContainer().add(nameText);
    getContainer().add(new JLabel("Comp.:"));
    getContainer().add(lenText);

    TextListeners.addTextListener(nameText, mainPanel);
    TextListeners.addTextListener(lenText, mainPanel);
  }
}
