package tecgraf.javautils.gui.crud.gui.actions;

import java.awt.event.ActionEvent;

import javax.swing.Action;

import tecgraf.javautils.gui.crud.RegistrationImages;
import tecgraf.javautils.gui.crud.gui.main.RegistrationMainPanel;

/**
 * Ao do painel tabular
 * 
 * @author Tecgraf
 * @param <M> Model
 * @param <I> View
 */
public class RegistrationEditAction<M, I> extends
  RegistrationAction<M, I> {

  /**
   * {@inheritDoc}
   */
  @Override
  public void actionPerformed(ActionEvent e) {
    final RegistrationMainPanel<M, I> mainPanel = getMainPanel();
    final M object = mainPanel.getSelectedObject();
    if (object == null) {
      return;
    }
    mainPanel.setMode(RegistrationMainPanel.Mode.EDIT);
  }

  /**
   * Construtor
   * 
   * @param mainPanel painel
   */
  public RegistrationEditAction(RegistrationMainPanel<M, I> mainPanel) {
    super(mainPanel);

    putValue(Action.NAME, mainPanel.getString("edit.action"));
    putValue(Action.SMALL_ICON, RegistrationImages.ICON_EDIT_16);
    putValue(Action.SHORT_DESCRIPTION, mainPanel.getString("edit.tooltip"));
  }
}
