package tecgraf.javautils.gui.print;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterJob;
import java.text.DecimalFormat;
import java.util.Calendar;
import java.util.GregorianCalendar;

import javax.swing.table.DefaultTableModel;

/**
 * Exemplo de uso da classe {@link DefaultPrintableTable}.
 *
 * @author Tecgraf/PUC-Rio
 */
public class DefaultPrintableTableSample {

  /**
   * Mtodo de teste da classe.
   * 
   * @param args argumentos passados na linha de comando.
   * 
   * @throws Exception erro na impresso.
   */
  public static void main(String[] args) throws Exception {
    int numRows = 125;
    int numColumns = 6;
    Object[] names =
      new Object[] { "Navio", "Origem", "ETD", "Destino", "ETA",
          "Volume\n(1000 m3)" };
    Object[][] data = new Object[numRows][numColumns];
    Object[] ships =
      new Object[] { "Norma", "Nilza", "Clara", "Pero", "Restinga", "TBN",
          "TBN", "TBN", "TBN" };
    Object[] points =
      new Object[] { "Ilha D'gua", "Angra dos Reis", "Mucuripe", "Cabedelo",
          "Santos", "N/A" };
    double totalVolume = 0;
    for (int row = 0; row < numRows - 1; row++) {
      data[row][0] = ships[(int) Math.floor(Math.random() * ships.length)];
      data[row][1] = points[(int) Math.floor(Math.random() * points.length)];
      data[row][3] = points[(int) Math.floor(Math.random() * points.length)];
      if (data[row][1] == data[row][3])
        data[row][3] = points[points.length - 1];
      int days = (int) Math.floor((Math.random() - 0.5) * 30);
      Calendar cal = new GregorianCalendar();
      cal.add(Calendar.DAY_OF_MONTH, days);
      data[row][2] = cal.getTime();
      days = (int) Math.floor(Math.random() * 30);
      cal.add(Calendar.DAY_OF_MONTH, days);
      data[row][4] = cal.getTime();
      double volume = Math.random() * 1000;
      data[row][5] = volume;
      totalVolume += volume;
    }
    data[numRows - 1][0] = "Total";
    data[numRows - 1][numColumns - 1] = totalVolume;
    DefaultTableModel m1 = new DefaultTableModel(data, names);
    final PrintableTable t1 = new DefaultPrintableTable(m1);
    t1.setTitle("Mapa de Navegao de Cabotagem\nViagens Programadas",
      new Font("Serif", Font.BOLD, 14));
    t1.setTableHeader("Para alocao de petrleos.\nNo considera cabotagem"
      + " de derivados.", new Font("SansSerif", Font.ITALIC, 8));
    t1.setPosText("Terminal N/A: indefinido.", new Font("SansSerif",
      Font.ITALIC, 8));
    t1
      .setColumnNameFont(0, numColumns - 1, new Font("SansSerif", Font.BOLD, 9));
    t1.setCellFont(0, numRows - 1, 0, 0, new Font("SansSerif", Font.BOLD, 65));
    t1.setCellFont(numRows - 1, numRows - 1, numColumns - 1, numColumns - 1,
      new Font("SansSerif", Font.BOLD, 9));

    t1.setDefaultFont(new Font("SansSerif", Font.PLAIN, 9));
    t1.setDecimalFormat(new DecimalFormat("#.00"));
    t1.setLineWidth(0);
    t1.setInsets(1, 1);
    PrinterJob job = PrinterJob.getPrinterJob();
    job.setPrintable(new Printable() {
      int lastPage = 0;
      boolean finished = false;

      public int print(Graphics g, PageFormat format, int page) {
        if (finished && page > lastPage)
          return NO_SUCH_PAGE;
        lastPage = page;
        format = (PageFormat) format.clone();
        Graphics2D g2d = (Graphics2D) g;
        g2d.setPaint(Color.black);
        finished = t1.print(g2d, format, page);
        Rectangle2D bbox =
          new Rectangle2D.Double(format.getImageableX(),
            format.getImageableY(), format.getImageableWidth(), format
              .getImageableHeight());
        g2d.setStroke(new BasicStroke(0, BasicStroke.CAP_BUTT,
          BasicStroke.JOIN_BEVEL));
        g2d.setPaint(Color.red);
        g2d.draw(bbox);
        return PAGE_EXISTS;
      }
    });
    job.printDialog();
    job.print();
    System.out.println("Digite <enter> para terminar.");
    System.in.read();
    System.exit(0);
  }
}
