package tecgraf.javautils.gui.print;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterJob;
import java.io.File;

import javax.swing.ImageIcon;

/**
 * Exemplo de uso da classe {@link PrintableHeader}.
 *
 * @author Tecgraf/PUC-Rio
 */
public class PrintableHeaderSample {
  
  /**
   * Mtodo de teste da classe.
   * 
   * @param args argumentos passados na linha de comando.
   * 
   * @throws Exception erro na impresso.
   */
  public static void main(String[] args) throws Exception {
    if (args.length < 2) {
      System.out.println("Fornea o nome de dois arquivos de imagens.");
      System.exit(-1);
    }
    File fimg0 = new File(args[0]);
    File fimg1 = new File(args[1]);
    if (!fimg0.exists() || !fimg1.exists()) {
      System.out.println("Arquivo no existe.");
      System.exit(-1);
    }
    ImageIcon img0 = new ImageIcon(args[0]);
    ImageIcon img1 = new ImageIcon(args[1]);
    final PrintableHeader header = new PrintableHeader(img0, img1);
    PrinterJob job = PrinterJob.getPrinterJob();
    job.setPrintable(new Printable() {
      public int print(Graphics g, PageFormat format, int page) {
        if (page > 0)
          return NO_SUCH_PAGE;
        format = (PageFormat) format.clone();
        Graphics2D g2d = (Graphics2D) g;
        g2d.setPaint(Color.black);
        header.print(g2d, format, page);
        return PAGE_EXISTS;
      }
    });
    job.printDialog();
    job.print();
    System.out.println("Digite <enter> para terminar.");
    System.in.read();
    System.exit(0);
  }
}
