/*
 * $Id$
 */
package tecgraf.javautils.gui.print;

/**
 * Agrupamento de colunas de uma tabela.
 * 
 * @author Giovani
 */
public class TableColumnGroup {
  /** O nome do agrupamento */
  private String name;
  /** O ndice da primeira coluna que pertence ao agrupamento */
  private int startIndex;
  /** O ndice da ltima coluna que pertence ao agrupamento */
  private int endIndex;

  /**
   * Construtor.
   * 
   * @param name o nome do agrupamento.
   * @param startIndex o ndice da primeira coluna que pertence ao agrupamento.
   * @param endIndex o ndice da ltima coluna que pertence ao agrupamento.
   */
  public TableColumnGroup(String name, int startIndex, int endIndex) {
    this.name = name;
    this.startIndex = startIndex;
    this.endIndex = endIndex;
  }

  /**
   * Recupera o nome do agrupamento.
   * 
   * @return o nome do agrupamento.
   */
  public String getName() {
    return name;
  }

  /**
   * Recupera o ndice da primeira coluna que pertence ao agrupamento.
   * 
   * @return o ndice da primeira coluna que pertence ao agrupamento.
   */
  public int getStartIndex() {
    return startIndex;
  }

  /**
   * Recupera o ndice da ltima coluna que pertence ao agrupamento.
   * 
   * @return o ndice da ltima coluna que pertence ao agrupamento.
   */
  public int getEndIndex() {
    return endIndex;
  }

}
