package tecgraf.javautils.gui.table;

import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

/**
 * Implementa com valores padres os mtodos opcionais da interface
 * {@link IColumn}.
 * 
 * @param <O> Tipo do objeto representado pela linha da tabela.
 * 
 * @author Tecgraf
 */
public abstract class AbstractColumn<O> implements IColumn<O> {

  /** Classe da propriedade do objeto que  representada por esta coluna. */
  private Class<?> clazz;

  /**
   * Construtor.
   * 
   * @param clazz classe da propriedade do objeto que  representada por esta
   *        coluna.
   */
  protected AbstractColumn(Class<?> clazz) {
    this.clazz = clazz;
  }

  /**
   * <p>
   * O padro  retornar {@code null}, forando assim que a tabela utilize o seu
   * {@link TableCellEditor} padro.
   * </p>
   * <p>
   * {@inheritDoc}
   * </p>
   */
  @Override
  public TableCellEditor createTableCellEditor() {
    return null;
  }

  /**
   * <p>
   * O padro  retornar {@code null}, forando assim que a tabela utilize o seu
   * {@link TableCellRenderer} padro.
   * </p>
   * <p>
   * {@inheritDoc}
   * </p>
   */
  @Override
  public TableCellRenderer createTableCellRenderer() {
    return null;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public final Class<?> getColumnClass() {
    return this.clazz;
  }

  /**
   * <p>
   * O padro  <tt>false</tt>.
   * </p>
   * <p>
   * {@inheritDoc}
   * </p>
   */
  @Override
  public boolean isEditable(O obj) {
    return false;
  }

  /**
   * <p>
   * O padro  no fazer nada. <br>
   * Este mtodo deve ser sobrescrito caso a propriedade representada por esta
   * coluna possa ser editvel em algum objeto da tabela.
   * </p>
   * <p>
   * {@inheritDoc}
   * </p>
   */
  @Override
  public void setValue(O obj, Object value) {
    // O padro  uma coluna no ser editvel. 
  }
}
