/*
 * Filter.java
 *
 * $Author: letnog $
 * $Revision: 1989 $  - $Date: 2005-10-13 10:14:07 -0300 (Thu, 13 Oct 2005) $
 */
package tecgraf.javautils.gui.table;

import javax.swing.table.TableModel;

/**
 * Interface que modela um filtro para uma tabela.
 */
public interface Filter {
  
  /**
   * Indica se a linha deve ser apresentada na tabela.
   * 
   * @param model modelo da tabela a ser filtrada.
   * @param row linha a ser apresentada ou no.
   * 
   * @return verdadeiro se a linha tiver que ser apresentada na tabela.
   */
  public boolean includes(TableModel model, int row);
}
