package tecgraf.javautils.gui.table;

import javax.swing.tree.TreeModel;

/**
 * Interface do modelo da TreeTable.
 *
 * @author Tecgraf/PUC-Rio
 */
public interface TreeTableModel extends TreeModel {

  /**
   * Retorna o nmero de colunas disponveis.
   *
   * @return nmero de colunas
   */
  public int getColumnCount();

  /**
   * Retorna o nome da coluna.
   *
   * @param column nmero da coluna.
   * @return nome da coluna.
   */
  public String getColumnName(int column);

  /**
   * Retorna o tipo (classe) de uma coluna. A coluna que contm a rvore deve
   * retornar {@link TreeTableModel} (a classe dessa interface).
   *
   * @param column nmero da coluna.
   * @return classe da coluna.
   */
  public Class<?> getColumnClass(int column);

  /**
   * Retorna o valor de um n em uma coluna.
   *
   * @param node n.
   * @param column nmero da coluna.
   * @return valor do n da coluna.
   */
  public Object getValueAt(Object node, int column);

  /**
   * Checa se uma clula de um n em uma coluna  editvel
   *
   * @param node n.
   * @param column nmero da coluna.
   * @return true/false
   */
  public boolean isCellEditable(Object node, int column);

  /**
   * Seta o valor para um n em uma coluna.
   *
   * @param aValue novo valor.
   * @param node n.
   * @param column nmero da coluna.
   */
  public void setValueAt(Object aValue, Object node, int column);
}
