package tecgraf.javautils.gui.wizard.utils.leftdecorations;

import java.awt.Color;
import java.awt.Component;
import java.awt.Image;

import tecgraf.javautils.gui.imagepanel.ImagePanel;
import tecgraf.javautils.gui.wizard.History;
import tecgraf.javautils.gui.wizard.ILeftDecoration;
import tecgraf.javautils.gui.wizard.Step;
import tecgraf.javautils.gui.wizard.WizardException;

/**
 * Panel decorador com imagem esttica (que no se altera no decorrer dos
 * passos).
 *
 * @author Tecgraf/PUC-Rio
 */
public class ImageLeftDecoration implements ILeftDecoration {

  /**
   * Painel de imagem.
   */
  final private ImagePanel imagePanel = new ImagePanel();

  /**
   * Construtor.
   *
   * @param image imagem
   * @param horAlign alinhamento horizontal
   * @param verAlign alinhamento vertical
   * @param backgroundColor cor de fundo
   */
  public ImageLeftDecoration(Image image, ImagePanel.HorAlign horAlign,
    ImagePanel.VerAlign verAlign, Color backgroundColor) {
    imagePanel.setHorAlign(horAlign);
    imagePanel.setVerAlign(verAlign);
    imagePanel.setImage(image);
    imagePanel.setBackground(backgroundColor);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void wasCancelled(Step step) {
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void wasClosed(Step step) {
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void wasConfirmed(Step step, Object result) {
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void wasGoneNext(Step currentStep, History history) {
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void wasGonePrevious(Step currentStep, History history) {
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void wasHappenedException(Step step, WizardException exception) {
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public Component getComponent() {
    return imagePanel;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public boolean isSplitPaneNeeded() {
    return true;
  }
}
