/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.javautils.gui.selector;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.ListSelectionModel;
import javax.swing.RowFilter;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableRowSorter;
import tecgraf.javautils.gui.SwingThreadDispatcher;
import tecgraf.javautils.gui.selector.ItemContainerEvent;
import tecgraf.javautils.gui.selector.ItemContainerListener;
import tecgraf.javautils.gui.table.ObjectTableModel;
import tecgraf.javautils.gui.table.ObjectTableProvider;
import tecgraf.javautils.gui.table.SortableTable;

public class ItemContainer<T> {
    private SortableTable container;
    private ObjectTableModel<T> itemContainerModel;
    private JScrollPane view;
    private JButton removeSelectedButton;
    private JButton removeAllButton;
    private boolean enabled;
    private List<ItemContainerListener> itemListeners;
    private boolean adjustToMinimumWidth;
    private Dimension minimunSize = new Dimension(0, 0);
    private ArrayList<Integer> colunsMinimunSize;
    private boolean isPendingColumnAdjustment = false;
    private TableRowSorter<ObjectTableModel> trs;

    JComponent getView() {
        return this.view;
    }

    List<T> getAll() {
        return this.itemContainerModel.getRows();
    }

    void load(Collection<T> elements) {
        if (elements == null) {
            throw new IllegalArgumentException("elements == null");
        }
        int countInserted = elements.size();
        this.itemContainerModel.addAll(elements);
        this.itemContainerModel.fireTableDataChanged();
        if (countInserted == 0) {
            this.removeAllButton.setEnabled(false);
        } else {
            this.removeAllButton.setEnabled(this.enabled);
        }
        this.updateTableAdjustment();
    }

    Collection<T> removeSelectedElements() {
        int[] viewRowIndexes = this.container.getSelectedRows();
        int viewRowIndexesLength = viewRowIndexes.length;
        int[] modelRowIndexes = new int[viewRowIndexesLength];
        for (int i = 0; i < viewRowIndexesLength; ++i) {
            modelRowIndexes[i] = this.container.convertRowIndexToModel(viewRowIndexes[i]);
        }
        Collection<T> status = this.itemContainerModel.removeAll(modelRowIndexes);
        this.updateTableAdjustment();
        return status;
    }

    Collection<T> removeAll() {
        this.removeSelectedButton.setEnabled(false);
        this.removeAllButton.setEnabled(false);
        Collection<T> status = this.itemContainerModel.removeAll();
        this.updateTableAdjustment();
        return status;
    }

    private void updateTableAdjustment() {
        if (this.adjustToMinimumWidth) {
            this.updateMinimunSize();
        }
        this.isPendingColumnAdjustment = true;
        this.view.invalidate();
    }

    boolean hasSelectedItems() {
        ListSelectionModel listModel = this.container.getSelectionModel();
        return listModel.getMinSelectionIndex() != -1;
    }

    public void addItemContainerListener(ItemContainerListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Listener = null == Illegal ");
        }
        this.itemListeners.add(listener);
    }

    public boolean removeItemContainerListener(ItemContainerListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Listener = null == Illegal ");
        }
        return this.itemListeners.remove(listener);
    }

    void setEnabled(boolean enabled) {
        this.enabled = enabled;
        this.container.setEnabled(enabled);
        if (!enabled) {
            this.removeAllButton.setEnabled(false);
            this.removeSelectedButton.setEnabled(false);
        }
    }

    public SortableTable getTable() {
        return this.container;
    }

    ItemContainer(ObjectTableProvider columnFormatter, JButton removeSelectedButton, JButton removeAllButton, boolean enabled) {
        this(columnFormatter, removeSelectedButton, removeAllButton, enabled, true, false);
    }

    ItemContainer(ObjectTableProvider columnFormatter, final JButton removeSelectedButton, final JButton removeAllButton, final boolean enabled, boolean enableSort, boolean adjustColumnsWidth) {
        this.removeSelectedButton = removeSelectedButton;
        this.removeAllButton = removeAllButton;
        this.enabled = enabled;
        this.adjustToMinimumWidth = adjustColumnsWidth;
        this.itemContainerModel = new ObjectTableModel(new ArrayList(), columnFormatter);
        this.container = new SortableTable(this.itemContainerModel, enableSort);
        this.trs = new TableRowSorter<ObjectTableModel<T>>(this.itemContainerModel);
        this.container.setRowSorter(this.trs);
        this.container.setNoSortStateEnabled(true);
        this.container.setEnabled(enabled);
        this.container.setAutoResizeMode(0);
        final ListSelectionModel listModel = this.container.getSelectionModel();
        listModel.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent ev) {
                if (listModel.getMinSelectionIndex() != -1) {
                    removeSelectedButton.setEnabled(enabled);
                } else {
                    removeSelectedButton.setEnabled(false);
                }
            }
        });
        listModel.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent ev) {
                if (!ev.getValueIsAdjusting()) {
                    ItemContainer.this.notifySelectionChange();
                }
            }
        });
        this.itemContainerModel.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent ev) {
                if (ItemContainer.this.itemContainerModel.getRowCount() == 0) {
                    removeAllButton.setEnabled(false);
                } else {
                    removeAllButton.setEnabled(enabled);
                }
            }
        });
        this.view = new JScrollPane(this.container){

            @Override
            public void validate() {
                super.validate();
                if (this.viewport.isValid() && ItemContainer.this.isPendingColumnAdjustment) {
                    ItemContainer.this.adjustLastColumnWidth();
                    super.validate();
                    SwingThreadDispatcher.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            ItemContainer.this.isPendingColumnAdjustment = false;
                        }
                    });
                }
            }

            @Override
            public boolean isValid() {
                if (ItemContainer.this.isPendingColumnAdjustment) {
                    return false;
                }
                return super.isValid();
            }
        };
        this.view.setPreferredSize(new Dimension(200, 70));
        this.view.validate();
        this.view.addComponentListener(new ComponentListener(){

            @Override
            public void componentHidden(ComponentEvent e) {
            }

            @Override
            public void componentMoved(ComponentEvent e) {
            }

            @Override
            public void componentResized(ComponentEvent e) {
                ItemContainer.this.isPendingColumnAdjustment = true;
                ItemContainer.this.view.validate();
            }

            @Override
            public void componentShown(ComponentEvent e) {
            }
        });
        this.itemListeners = new LinkedList<ItemContainerListener>();
        this.updateTableAdjustment();
    }

    private void adjustLastColumnWidth() {
        if (this.container.getColumnCount() == 0) {
            return;
        }
        int viewportWidth = (int)this.view.getViewport().getSize().getWidth();
        int tableWidth = this.container.getWidth();
        if (this.adjustToMinimumWidth) {
            if (viewportWidth <= this.minimunSize.width) {
                this.container.setSize(this.minimunSize);
                this.doAdjustColumnWidth(this.minimunSize.width);
                this.container.validate();
                return;
            }
            this.container.setSize(new Dimension(viewportWidth, this.minimunSize.height));
            this.container.adjustColumnWidth();
            this.doAdjustColumnWidth(viewportWidth);
            this.container.validate();
            return;
        }
        if (viewportWidth < tableWidth) {
            return;
        }
        TableColumnModel columnModel = this.container.getColumnModel();
        TableColumn lastColumn = columnModel.getColumn(this.container.getColumnCount() - 1);
        lastColumn.setWidth(lastColumn.getPreferredWidth() + viewportWidth - tableWidth);
        this.container.validate();
    }

    private void doAdjustColumnWidth(int width) {
        int numColumns = this.container.getColumnCount();
        int tableSize = 0;
        if (this.colunsMinimunSize.isEmpty() || this.container.getRowCount() == 0) {
            int viewportWidth = (int)this.view.getViewport().getSize().getWidth();
            int quotient = viewportWidth / numColumns;
            int modulus = viewportWidth % numColumns;
            for (int i = 0; i < numColumns; ++i) {
                int delta = modulus-- > 0 ? quotient + 1 : quotient;
                TableColumnModel columnModel = this.container.getColumnModel();
                TableColumn column = columnModel.getColumn(i);
                column.setPreferredWidth(delta);
                tableSize += delta;
            }
            return;
        }
        for (int i = 0; i < numColumns; ++i) {
            TableColumnModel columnModel = this.container.getColumnModel();
            TableColumn column = columnModel.getColumn(i);
            column.setPreferredWidth(this.colunsMinimunSize.get(i));
            tableSize += this.colunsMinimunSize.get(i).intValue();
        }
        TableColumnModel columnModel = this.container.getColumnModel();
        TableColumn lastColumn = columnModel.getColumn(this.container.getColumnCount() - 1);
        lastColumn.setPreferredWidth(lastColumn.getPreferredWidth() + width - tableSize);
        this.container.setSize(new Dimension(width, this.minimunSize.height));
    }

    private void updateMinimunSize() {
        int width = this.getMinimunTableWidth();
        int height = this.getTableHeight();
        this.minimunSize = new Dimension(width, height);
    }

    private int getMinimunTableWidth() {
        int numColumns = this.container.getColumnCount();
        int tableWidth = 0;
        this.colunsMinimunSize = new ArrayList();
        for (int i = 0; i < numColumns; ++i) {
            TableColumnModel columnModel = this.container.getColumnModel();
            TableColumn column = columnModel.getColumn(i);
            int width = 0;
            TableCellRenderer renderer = column.getHeaderRenderer();
            if (renderer == null) {
                renderer = this.container.getTableHeader().getDefaultRenderer();
            }
            Component comp = renderer.getTableCellRendererComponent(this.container, column.getHeaderValue(), false, false, 0, 0);
            width = comp.getPreferredSize().width;
            for (int r = 0; r < this.container.getRowCount(); ++r) {
                renderer = this.container.getCellRenderer(r, 0);
                comp = renderer.getTableCellRendererComponent(this.container, this.container.getValueAt(r, i), false, false, r, i);
                width = Math.max(width, comp.getPreferredSize().width);
            }
            this.colunsMinimunSize.add(i, width += this.container.getIntercellSpacing().width * 2);
            tableWidth += width;
        }
        return tableWidth;
    }

    private int getTableHeight() {
        int rowCount = this.container.getRowCount();
        int tableHeight = 0;
        for (int i = 0; i < rowCount; ++i) {
            int prefRowHeight = 0;
            int colCount = this.container.getColumnCount();
            for (int c = 0; c < colCount; ++c) {
                int prefCellHeight = this.container.getRowHeight(i);
                if (prefCellHeight <= prefRowHeight) continue;
                prefRowHeight = prefCellHeight;
            }
            tableHeight += prefRowHeight;
        }
        return tableHeight;
    }

    private void notifySelectionChange() {
        LinkedList<T> l = new LinkedList<T>();
        int[] indexSelected = this.container.getSelectedRows();
        for (int i = 0; i < indexSelected.length; ++i) {
            l.add(this.itemContainerModel.getRow(indexSelected[i]));
        }
        ItemContainerEvent event = new ItemContainerEvent(this, l);
        for (ItemContainerListener listener : this.itemListeners) {
            listener.wasSelected(event);
        }
    }

    public void filter(String toFilter) {
        if (toFilter.isEmpty()) {
            this.trs.setRowFilter(null);
        } else {
            this.trs.setRowFilter(RowFilter.regexFilter("(?i)" + toFilter, new int[0]));
        }
        this.updateTableAdjustment();
    }
}

