/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.javautils.jexpression.scanner;

import java.util.regex.Matcher;
import tecgraf.javautils.jexpression.scanner.Symbol;
import tecgraf.javautils.jexpression.scanner.Token;

public class JScanner {
    private String input;
    private int lineNumber;
    private int index;

    public JScanner(String string) {
        if (string == null) {
            throw new IllegalArgumentException("input n\u00e3o pode ser nulo.");
        }
        this.input = string;
        this.lineNumber = 1;
        this.index = 0;
    }

    public Token nextToken() {
        this.normalize();
        if (this.over()) {
            return null;
        }
        for (Symbol symbol : Symbol.values()) {
            Matcher matcher = symbol.pattern.matcher(this.input);
            matcher.region(this.index, this.input.length());
            if (!matcher.find()) continue;
            this.index = matcher.end();
            return new Token(symbol, this.lineNumber, matcher.group());
        }
        return null;
    }

    private void normalize() {
        if (this.over()) {
            return;
        }
        char c = this.input.charAt(this.index);
        if (c == ' ' || c == '\n' || c == '\t') {
            ++this.index;
            if (c == '\n') {
                ++this.lineNumber;
            }
            this.normalize();
        }
    }

    public boolean over() {
        return this.input.length() == 0 || this.index == this.input.length();
    }
}

