package tecgraf.javautils.jexpression.parser.model;

/**
 * Classe que armazena uma valor numrico em formato {@link Double}.
 * 
 * Ex: 3, 3.0, 3.14, 5.1e+2, 5.1E+2, 5.1e-2, 5.1E-2
 * 
 * @author Tecgraf
 */
public class DoubleValue extends Exp {

  /** Valor em {@link Double}. */
  private double value;

  /**
   * Construtor.
   * 
   * @param value valor.
   */
  public DoubleValue(double value) {
    this.value = value;
  }

  /**
   * Valor.
   * 
   * @return valor.
   */
  public double getValue() {
    return value;
  }

  /** {@inheritDoc} */
  @Override
  public String toString() {
    return Double.toString(value);
  }
}
