package tecgraf.javautils.jexpression.parser.model;

/**
 * Classe que armazena uma varivel.
 * 
 * Ex: a, b, abc
 * 
 * @author Tecgraf
 */
public class Var extends Exp {

  /** Nome. */
  private String name;

  /**
   * Construtor.
   * 
   * @param name nome.
   */
  public Var(String name) {
    if (name == null) {
      throw new IllegalArgumentException("name no pode ser nulo.");
    }
    this.name = name;
  }

  /**
   * Nome.
   * 
   * @return nome.
   */
  public String getName() {
    return name;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public String toString() {
    return name;
  }
}
