package tecgraf.javautils.jexpression.util.function;

/**
 * Conjunto de funes pr-definidas que recebem apenas um parmetro do tipo
 * {@link Double}.
 * 
 * @author Tecgraf
 */
public enum MathSingleFunctions {

  /** exp. */
  EXP {
    @Override
    public JExpressionSingleFunction<Double> getFunction() {
      return new JExpressionSingleFunction<Double>("exp") {
        @Override
        public Double invoke(Double param) {
          return Math.exp(param);
        }
      };
    }
  },

  /** log10. */
  LOG10 {
    @Override
    public JExpressionSingleFunction<Double> getFunction() {
      return new JExpressionSingleFunction<Double>("log10") {
        @Override
        public Double invoke(Double param) {
          return Math.log10(param);
        }
      };
    }
  },

  /** log. */
  LOG {
    @Override
    public JExpressionSingleFunction<Double> getFunction() {
      return new JExpressionSingleFunction<Double>("log") {
        @Override
        public Double invoke(Double param) {
          return Math.log(param);
        }
      };
    }
  },

  /** Valor arredondado. */
  ROUND {
    @Override
    public JExpressionSingleFunction<Double> getFunction() {
      return new JExpressionSingleFunction<Double>("round") {
        @Override
        public Double invoke(Double param) {
          return ((Long) Math.round(param)).doubleValue();
        }
      };
    }
  },

  /** Floor. */
  FLOOR {
    @Override
    public JExpressionSingleFunction<Double> getFunction() {
      return new JExpressionSingleFunction<Double>("floor") {
        @Override
        public Double invoke(Double param) {
          return Math.floor(param);
        }
      };
    }
  },

  /** Valor absoluto. */
  ABS {
    @Override
    public JExpressionSingleFunction<Double> getFunction() {
      return new JExpressionSingleFunction<Double>("abs") {
        @Override
        public Double invoke(Double param) {
          return Math.abs(param);
        }
      };
    }
  },

  /** Raiz cbica. */
  CBRT {
    @Override
    public JExpressionSingleFunction<Double> getFunction() {
      return new JExpressionSingleFunction<Double>("cbrt") {
        @Override
        public Double invoke(Double param) {
          return Math.cbrt(param);
        }
      };
    }
  },

  /** Raiz quadrada. */
  SQRT {
    @Override
    public JExpressionSingleFunction<Double> getFunction() {
      return new JExpressionSingleFunction<Double>("sqrt") {
        @Override
        public Double invoke(Double param) {
          return Math.sqrt(param);
        }
      };
    }
  },

  /** Tangente. */
  TAN {
    @Override
    public JExpressionSingleFunction<Double> getFunction() {
      return new JExpressionSingleFunction<Double>("tan") {
        @Override
        public Double invoke(Double param) {
          return Math.tan(param);
        }
      };
    }
  },

  /** Seno. */
  SIN {
    @Override
    public JExpressionSingleFunction<Double> getFunction() {
      return new JExpressionSingleFunction<Double>("sin") {
        @Override
        public Double invoke(Double param) {
          return Math.sin(param);
        }
      };
    }
  },

  /** Cosseno. */
  COS {
    @Override
    public JExpressionSingleFunction<Double> getFunction() {
      return new JExpressionSingleFunction<Double>("cos") {
        @Override
        public Double invoke(Double param) {
          return Math.cos(param);
        }
      };
    }
  };

  /**
   * Funo.
   * 
   * @return funo.
   */
  abstract public JExpressionSingleFunction<Double> getFunction();
}
