package tecgraf.javautils.jexpression.parser.model;

/**
 * Classe que armazena um agrupamento.
 * 
 * Ex: (a + b), -(a + b), (a * (b + c))
 * 
 * @author Tecgraf
 */
public class Group extends Exp {

  /** Expresso. */
  private Exp expression;

  /**
   * Construtor.
   * 
   * @param expression expresso.
   */
  public Group(Exp expression) {
    if (expression == null) {
      throw new IllegalArgumentException("exp no pode ser nulo.");
    }
    this.expression = expression;
  }

  /**
   * Expresso.
   * 
   * @return expresso.
   */
  public Exp getExpression() {
    return expression;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public String toString() {
    return String.format("(%s)", expression);
  }
}
