package tecgraf.javautils.jexpression.parser.model;

/**
 * Classe que armazena um acesso de ndice.
 * 
 * Ex: a[i], a[i + 1]
 * 
 * @author Tecgraf
 */
public class Index extends Exp {

  /** Expresso. */
  private Exp expression;

  /** ndice. */
  private Exp index;

  /**
   * Construtor.
   * 
   * @param expression expresso.
   * @param index ndice.
   */
  public Index(Exp expression, Exp index) {
    if (expression == null) {
      throw new IllegalArgumentException("expression no pode ser nulo.");
    }
    if (index == null) {
      throw new IllegalArgumentException("index no pode ser nulo.");
    }
    this.expression = expression;
    this.index = index;
  }

  /**
   * Expresso.
   * 
   * @return expresso.
   */
  public Exp getExpression() {
    return expression;
  }

  /**
   * Nome.
   * 
   * @return nome.
   */
  public Exp getIndex() {
    return index;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public String toString() {
    return String.format("%s[%s]", expression, index);
  }

}
