package tecgraf.javautils.jexpression.util;

import java.util.HashSet;
import java.util.List;
import java.util.Set;

import tecgraf.javautils.jexpression.JExpressionHandler;
import tecgraf.javautils.jexpression.exception.JExpressionException;

/**
 * Tratador que lista o nome de todas as variveis de uma expresso.
 * 
 * @author Tecgraf
 */
public class VarNamesHandler implements JExpressionHandler {

  /** Conjunto com os nomes das variveis. */
  private Set<String> names;

  /** Construtor. */
  public VarNamesHandler() {
    names = new HashSet<String>();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public Object handleDouble(Double value) throws JExpressionException {
    return names;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public Object handlePlus(Object first, Object second)
    throws JExpressionException {
    return names;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public Object handleMinus(Object first, Object second)
    throws JExpressionException {
    return names;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public Object handleTimes(Object first, Object second)
    throws JExpressionException {
    return names;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public Object handleDivision(Object first, Object second)
    throws JExpressionException {
    return names;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public Object handlePow(Object first, Object second)
    throws JExpressionException {
    return names;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public Object handleOr(Object first, Object second)
    throws JExpressionException {
    return names;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public Object handleAnd(Object first, Object second)
    throws JExpressionException {
    return names;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public Object handleEqual(Object first, Object second)
    throws JExpressionException {
    return names;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public Object handleNotEqual(Object first, Object second)
    throws JExpressionException {
    return names;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public Object handleGreater(Object first, Object second)
    throws JExpressionException {
    return names;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public Object handleGreaterEqual(Object first, Object second)
    throws JExpressionException {
    return names;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public Object handleLower(Object first, Object second)
    throws JExpressionException {
    return names;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public Object handleLowerEqual(Object first, Object second)
    throws JExpressionException {
    return names;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public Object handleQuestion(Object condition, Object then, Object otherwise)
    throws JExpressionException {
    return names;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public Object handleUnaryMinus(Object object) throws JExpressionException {
    return names;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public Object handleNot(Object object) throws JExpressionException {
    return names;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public Object handleVar(String name) throws JExpressionException {
    names.add(name);
    return names;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public Object handleIndex(Object object, Object index)
    throws JExpressionException {
    return names;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public Object handleField(Object object, String field)
    throws JExpressionException {
    return names;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public Object handleFunctionCall(String functionName, List<Object> params)
    throws JExpressionException {
    return names;
  }
}
