package tecgraf.javautils.jexpression.util.function;

import tecgraf.javautils.jexpression.util.CalculatorHandler;

/**
 * Classe que encapsula uma funo usada no tratador {@link CalculatorHandler}.
 * 
 * @author Tecgraf
 */
public abstract class JExpressionFunction {

  /** Nome da funo. */
  private String name;

  /**
   * Construtor.
   * 
   * @param name nome.
   */
  public JExpressionFunction(String name) {
    if (name == null) {
      throw new IllegalArgumentException("name no pode ser nulo.");
    }
    this.name = name;
  }

  /**
   * Nome.
   * 
   * @return nome.
   */
  public String getName() {
    return name;
  }

  /**
   * Executa a chamada da funo.
   * 
   * @param params parmetros.
   * @return retorno da funo.
   */
  public abstract Object call(Object... params);
}
