package tecgraf.javautils.jexpression.scanner;

import java.util.regex.Pattern;

/**
 * Enumerao que define os smbolos da linguagem de expresses.
 *
 * A ordem da declarao dos smbolos  relevante para a anlise lxica, por
 * exemplo, o operador {@code >=} deve preceder o operador {@code >} por terem o
 * mesmo prefixo. Basicamente, essa ordem serve para definir uma ordem no
 * reconhecimento dos smbolos.
 *
 * @author Tecgraf
 */
public enum Symbol {

  /** maior ou igual. */
  GREATER_EQ(">=", ">="),

  /** maior que. */
  GREATER(">", ">"),

  /** menor ou igual. */
  LOWER_EQ("<=", "<="),

  /** menor que. */
  LOWER("<", "<"),

  /** soma. */
  PLUS("+", "\\+"),

  /** vrgula. */
  COMMA(",", ","),

  /** substrao. */
  MINUS("-", "\\-"),

  /** diviso. */
  DIVIDE("/", "\\/"),

  /** multiplicao. */
  TIMES("*", "\\*"),

  /** exponenciao. */
  POW("^", "\\^"),

  /** condio. */
  QUESTION("?", "\\?"),

  /** seno. */
  COLON(":", ":"),

  /** parntese. */
  L_PAREN("(", "\\("),

  /** parntese. */
  R_PAREN(")", "\\)"),

  /** colchete. */
  L_BRACKET("[", "\\["),

  /** colchete. */
  R_BRACKET("]", "\\]"),

  /** igualdade. */
  EQUAL("==", "=="),

  /** diferente. */
  NOT_EQUAL("!=", "!="),

  /** negao. */
  NOT("!", "!"),

  /** e. */
  AND("&&", "\\&\\&"),

  /** ou. */
  OR("||", "\\|\\|"),

  /** ponto. */
  DOT(".", "\\."),

  /** nmero. */
  DOUBLE(null, "[0-9]*\\.[0-9]+([Ee][+-]?[0-9]+)?|[0-9]+"),

  /** nome. */
  NAME(null, "[_a-zA-Z][_a-zA-Z0-9]*"),

  /** Caracter desconhecido. */
  UNKNOWN(null, ".");

  /** Representao grfica do smbolo. */
  final public String graphic;

  /** Regex que reconhece o smbolo. */
  final public Pattern pattern;

  /**
   * Construtor.
   *
   * @param graphic representao grfica.
   * @param regex regex.
   */
  private Symbol(String graphic, String regex) {
    this.graphic = graphic;
    this.pattern = Pattern.compile(String.format("^(%s)", regex));
  }
}
