/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.javautils.jexpression.scanner;

import tecgraf.javautils.jexpression.scanner.Symbol;

public class Token {
    private Symbol type;
    private int lineNumber;
    private String value;

    Token(Symbol type, int lineNumber, String value) {
        if (type == null) {
            throw new IllegalArgumentException("type n\u00e3o pode ser nulo.");
        }
        if (lineNumber < 0) {
            throw new IllegalArgumentException("lineNumber n\u00e3o pode ser menor que zero.");
        }
        if (value == null) {
            throw new IllegalArgumentException("value n\u00e3o pode ser nulo.");
        }
        this.lineNumber = lineNumber;
        this.type = type;
        this.value = value;
    }

    public Symbol getType() {
        return this.type;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public String getValue() {
        return this.value;
    }

    public boolean isUnknown() {
        return this.type == Symbol.UNKNOWN;
    }

    public String toString() {
        return String.format("{%s,%s,%s}", new Object[]{this.type, this.lineNumber, this.value});
    }
}

