package tecgraf.javautils.jexpression.parser.model;

import java.util.List;

/**
 * Classe que armazena uma chamada de funo.
 *
 * <p>
 * Exemplos:
 * <ul>
 * <li>max(10, 20)
 * <li>max(a, b)
 * <li>max(a[i], b[2])
 * <li>sen(x)
 * <li>value()
 * </ul>
 *
 * @author Tecgraf
 */
public class FunctionCall extends Exp {

  /** Nome da funo. */
  private String name;

  /** Parmetros. */
  private List<Exp> params;

  /**
   * Construtor.
   *
   * @param name nome.
   * @param params parmetros.
   */
  public FunctionCall(String name, List<Exp> params) {
    if (name == null) {
      throw new IllegalArgumentException("name no pode ser nulo.");
    }
    if (params == null) {
      throw new IllegalArgumentException("params no pode ser nulo.");
    }
    this.name = name;
    this.params = params;
  }

  /**
   * Nome.
   *
   * @return nome.
   */
  public String getName() {
    return name;
  }

  /**
   * Parmetros.
   *
   * @return parmetros.
   */
  public List<Exp> getParams() {
    return params;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public String toString() {
    StringBuilder args = new StringBuilder();
    for (int i = 0; i < params.size(); i++) {
      args.append(params.get(i));
      if (i < params.size() - 1) {
        args.append(", ");
      }
    }
    return String.format("%s(%s)", name, args);
  }
}
