package tecgraf.javautils.jexpression.parser.model;

import tecgraf.javautils.jexpression.scanner.Symbol;

/**
 * Classe que armazena uma operao unria. As operaes unrias possveis so
 * as seguintes: "-" e "&#33;"
 *
 * <p>
 * Abaixo listamos os outros tipos de operadores da linguagem.
 * <ul>
 * <li>Operador ternrio: {@link Question}
 * <li>Operador de acesso a campo: {@link Field}
 * <li>Operadores binrios: {@link BinaryOp}
 * </ul>
 *
 * <p>
 * Ex: <tt> !a, -a, !!a, --a </tt>
 *
 * @author Tecgraf
 */
public class UnaryOp extends Exp {

  /** Operador. */
  private Symbol op;

  /** Operando. */
  private Exp expression;

  /**
   * Construtor.
   *
   * @param op operador.
   * @param expression operando.
   */
  public UnaryOp(Symbol op, Exp expression) {
    if (op == null) {
      throw new IllegalArgumentException("op no pode ser nulo.");
    }
    if (expression == null) {
      throw new IllegalArgumentException("expression no pode ser nulo.");
    }
    this.op = op;
    this.expression = expression;
  }

  /**
   * Operador.
   *
   * @return operador.
   */
  public Symbol getOp() {
    return op;
  }

  /**
   * Operando.
   *
   * @return operando.
   */
  public Exp getExpression() {
    return expression;
  }

  /** {@inheritDoc} */
  @Override
  public String toString() {
    String graphic = getOp().graphic;
    return String.format("%s%s", graphic, expression);
  }

}
