package tecgraf.javautils.jexpression.scanner;

/**
 * Classe que encapsula um token da linguagem de expresses. Cada token 
 * composto pelo seu valor em {@link String}, um tipo definido na enumerao
 * {@link Symbol} e pelo nmero da liha.
 * 
 * @see Symbol
 * 
 * @author Tecgraf
 */
public class Token {

  /** Tipo do token. */
  private Symbol type;

  /** Nmero da linha. */
  private int lineNumber;

  /** Valor do token. */
  private String value;

  /**
   * Construtor.
   * 
   * @param type tipo do token.
   * @param lineNumber nmero da linha.
   * @param value valor.
   */
  Token(Symbol type, int lineNumber, String value) {
    if (type == null) {
      throw new IllegalArgumentException("type no pode ser nulo.");
    }
    if (lineNumber < 0) {
      throw new IllegalArgumentException(
        "lineNumber no pode ser menor que zero.");
    }
    if (value == null) {
      throw new IllegalArgumentException("value no pode ser nulo.");
    }
    this.lineNumber = lineNumber;
    this.type = type;
    this.value = value;
  }

  /**
   * Tipo do token.
   * 
   * @return tipo.
   */
  public Symbol getType() {
    return type;
  }

  /**
   * Nmero da linha do token.
   * 
   * @return nmero da linha.
   */
  public int getLineNumber() {
    return lineNumber;
  }

  /**
   * Valor.
   * 
   * @return valor.
   */
  public String getValue() {
    return value;
  }

  /**
   * Retorna true se o token for desconhecido, false caso contrrio.
   * 
   * @return flag que indica se o token  desconhecido.
   */
  public boolean isUnknown() {
    return type == Symbol.UNKNOWN;
  }

  /** {@inheritDoc} */
  @Override
  public String toString() {
    return String.format("{%s,%s,%s}", type, lineNumber, value);
  }
}
