/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.javautils.json;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.networknt.schema.JsonSchema;
import com.networknt.schema.JsonSchemaFactory;
import com.networknt.schema.ValidationMessage;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Iterator;
import java.util.Set;
import java.util.stream.Collectors;
import tecgraf.javautils.json.JuJsonObjectUtilities;
import tecgraf.javautils.json.JuJsonSchemaVersion;

public class JuJsonSchemaUtilities {
    public static JsonSchema createSchema(InputStream inputStream, JuJsonSchemaVersion schemaVersion) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
        String text = reader.lines().collect(Collectors.joining("\n"));
        return JuJsonSchemaUtilities.createSchema(text, schemaVersion);
    }

    public static JsonSchema createSchema(String schemaText, JuJsonSchemaVersion schemaVersion) throws IOException {
        JsonNode node = JuJsonObjectUtilities.jsonToNode(schemaText);
        if (!node.isObject()) {
            String err = "schema text does not represent an object!";
            throw new IOException("schema text does not represent an object!");
        }
        return JuJsonSchemaUtilities.createSchema(node, schemaVersion);
    }

    public static JsonSchema createSchema(JsonNode node, JuJsonSchemaVersion schemaVersion) throws IOException {
        if (!node.isObject()) {
            String err = "schema text does not represent an object!";
            throw new IOException("schema text does not represent an object!");
        }
        ObjectNode objectNode = (ObjectNode)node;
        JsonSchemaFactory factory = schemaVersion.createFactory();
        JsonSchema schema = factory.getSchema((JsonNode)objectNode);
        return schema;
    }

    public static <T> void validateSchemaObject(JsonSchema schema, T object, Class<T> clazz) throws IOException {
        String cnf = JuJsonObjectUtilities.objectToJson(object);
        JsonNode jsonNode = JuJsonObjectUtilities.jsonToNode(cnf);
        JuJsonSchemaUtilities.validateSchemaNode(schema, jsonNode);
    }

    public static void validateSchemaNode(JsonSchema schema, JsonNode jsonNode) throws IOException {
        Set validationMessages = schema.validate(jsonNode);
        boolean success = validationMessages.isEmpty();
        if (!success) {
            Iterator iterator = validationMessages.iterator();
            Object msg = "";
            if (iterator.hasNext()) {
                ValidationMessage next = (ValidationMessage)iterator.next();
                msg = (String)msg + next.getMessage() + "\n";
            }
            String fmt = "Object cannot be validated\n%s";
            String err = String.format("Object cannot be validated\n%s", msg);
            throw new IOException(err);
        }
    }
}

