/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.javautils.launcher;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Properties;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import tecgraf.javautils.launcher.Config;
import tecgraf.javautils.launcher.DefaultSplashScreen;
import tecgraf.javautils.launcher.Installer;
import tecgraf.javautils.launcher.LoggerFormatter;
import tecgraf.javautils.launcher.OS;
import tecgraf.javautils.launcher.SplashScreen;

abstract class Base {
    protected static final int DEFAULT_BUFFER_SIZE = 1024;
    protected static final Logger logger = Logger.getLogger("Launcher");
    protected static final String[] JAR_CMD = new String[]{"java", "-jar"};
    private Config config;
    private String version;
    private static final int DEFAULT_LOG_FILE_COUNT = 5;
    private static final int DEFAULT_LOG_FILE_LIMIT = 1000000;

    public Base() {
        logger.setUseParentHandlers(false);
        ConsoleHandler consoleHandler = new ConsoleHandler();
        consoleHandler.setFormatter(new LoggerFormatter());
        logger.addHandler(consoleHandler);
    }

    protected void loadVersionProperties() throws IOException {
        logger.info("Carregando arquivo de vers\u00e3o...");
        Properties properties = new Properties();
        properties.load(Installer.class.getResourceAsStream("/version.properties"));
        this.version = properties.getProperty("version");
        logger.info("Vers\u00e3o do launcher: " + this.version);
    }

    protected String getVersion() {
        return this.version;
    }

    protected SplashScreen buildSplashScreen(Config config) {
        DefaultSplashScreen splashScreen = new DefaultSplashScreen();
        ImageIcon icon = this.getIcon();
        if (icon != null) {
            splashScreen.setIconImage(icon.getImage());
        }
        splashScreen.setTitle(config.appAcronym + " - " + config.environment.acronym);
        splashScreen.setLocationRelativeTo(null);
        return splashScreen;
    }

    public final void start(String[] args) {
        try {
            this.loadVersionProperties();
            this.config = Config.load(logger);
            logger.setLevel(this.config.logLevel);
            String javaVersion = System.getProperty("java.version");
            if (javaVersion == null) {
                throw new IllegalStateException("N\u00e3o foi poss\u00edvel obter a vers\u00e3o do Java");
            }
            logger.info("Java version: " + javaVersion);
            OS os = OS.getOS();
            if (os == null) {
                throw new IllegalStateException("N\u00e3o foi poss\u00edvel obter o sistema operacional.");
            }
            this.execute(args, this.config, os);
        }
        catch (Exception e) {
            Base.logException(e);
            this.showErrorAndExit(e.getMessage());
        }
    }

    protected ImageIcon getIcon() {
        URL url = this.getClass().getResource("/" + this.config.resourceIconName);
        if (url != null) {
            return new ImageIcon(url);
        }
        return null;
    }

    protected abstract void execute(String[] var1, Config var2, OS var3) throws Exception;

    protected final void showErrorAndExit(String message) {
        try {
            SwingUtilities.invokeAndWait(() -> JOptionPane.showMessageDialog(null, message, "Erro", 0));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.exit(1);
    }

    protected static void logException(Exception e) {
        for (Throwable cause = e; cause != null; cause = cause.getCause()) {
            logger.severe(cause.getMessage());
            Arrays.asList(cause.getStackTrace()).forEach(elem -> logger.severe(elem.toString()));
        }
    }

    protected String getUserHome() {
        String userHome = System.getProperty("user.home");
        if (userHome == null) {
            throw new IllegalStateException("N\u00e3o foi poss\u00edvel obter o home do usu\u00e1rio utilizando a propriedade 'user.home'.");
        }
        return userHome;
    }

    protected final void setFileLogger(Path fileLog) throws IOException {
        FileHandler fileHandler = new FileHandler(fileLog.toString(), 1000000, 5, true);
        fileHandler.setFormatter(new LoggerFormatter());
        logger.addHandler(fileHandler);
    }

    protected final void download(SplashScreen splashScreen, String fileUrl, Path target) {
        URLConnection connection;
        logger.info("Iniciando download '" + fileUrl + "' para '" + target + "'");
        try {
            URL url = new URL(fileUrl);
            connection = url.openConnection();
        }
        catch (Exception e) {
            throw new IllegalStateException("Erro ao realizar download: " + fileUrl, e);
        }
        try (BufferedInputStream in = new BufferedInputStream(connection.getInputStream());
             BufferedOutputStream bout = new BufferedOutputStream(new FileOutputStream(target.toFile()), 1024);){
            int x;
            if (splashScreen != null) {
                SwingUtilities.invokeLater(() -> splashScreen.setProgressBarIndeterminate(false));
            }
            double completeFileSize = connection.getContentLength();
            byte[] data = new byte[1024];
            double downloadedFileSize = 0.0;
            while ((x = in.read(data, 0, 1024)) >= 0) {
                int currentProgress = (int)((downloadedFileSize += (double)x) / completeFileSize);
                if (splashScreen != null) {
                    SwingUtilities.invokeLater(() -> splashScreen.setProgressBarValue(currentProgress));
                }
                bout.write(data, 0, x);
            }
            logger.info("Download '" + fileUrl + "' finalizado com sucesso");
        }
        catch (Exception e) {
            throw new IllegalStateException("Erro ao realizar download: " + fileUrl, e);
        }
    }
}

