/*
 * $Id:
 */
package tecgraf.javautils.parsers;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

import tecgraf.javautils.parsers.symbols.Symbol;

/**
 * Representa um token utilizado por um autmato finito (
 * {@link tecgraf.javautils.parsers.FiniteAutomaton}).
 */
public class Token {
  /**
   * Contm os smbolos ({@link Symbol}) que representam o token.
   */
  final private List<Symbol<?>> symbolList;

  /**
   * Cria um token sem smbolos.
   */
  protected Token() {
    this.symbolList = new LinkedList<Symbol<?>>();
  }

  /**
   * Adiciona um smbolo ao token.
   * 
   * @param symbol O smbolo a ser inserido.
   * 
   * @return true, caso o smbolo tenha sido inserido, ou false, caso contrrio.
   */
  public final boolean addSymbol(Symbol<?> symbol) {
    return this.symbolList.add(symbol);
  }

  /**
   * Obtm a quantidade de smbolos do token.
   * 
   * @return A quantidade de smbolos do token.
   */
  public final int getSize() {
    return this.symbolList.size();
  }

  /**
   * Obtm a lista de smbolos que compe o token.
   * 
   * @return A lista de smbolos que compe o token.
   */
  public final List<Symbol<?>> getSymbolList() {
    return Collections.unmodifiableList(this.symbolList);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public final String toString() {
    StringBuffer buffer = new StringBuffer();
    Iterator<Symbol<?>> iterator = this.symbolList.iterator();
    while (iterator.hasNext()) {
      final Symbol<?> nextSymbol = iterator.next();
      buffer.append(nextSymbol);
    }
    final String string = buffer.toString();
    return string;
  }
}
