package tecgraf.javautils.parsers.actions;

import tecgraf.javautils.parsers.Session;
import tecgraf.javautils.parsers.symbols.Symbol;

/**
 *  a ao responsvel por adicionar o smbolo atual  sesso.
 */
public final class AppendAction implements TransitionAction {
  /**
   * A instncia nica.
   */
  private static AppendAction instance;

  /**
   * Obtm a instncia nica.
   * 
   * @return A instncia nica.
   */
  public static AppendAction getInstance() {
    if (instance == null) {
      instance = new AppendAction();
    }
    return instance;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void execute(final Symbol<?> symbol, final Session session) {
    if (symbol == null) {
      final String err =
        "O smbolo que est sendo utilizado pelo autmato no pode ser nulo (null).";
      throw new IllegalArgumentException(err);
    }
    if (session == null) {
      final String err = "A sesso de execuo no pode ser nula (null).";
      throw new IllegalArgumentException(err);
    }
    session.appendSymbol(symbol);
  }

  /**
   * Construtor definido para impedir a criao de objetos desta classe
   * externamente.
   */
  private AppendAction() {
  }
}
