package tecgraf.javautils.parsers.actions;

import tecgraf.javautils.parsers.Session;
import tecgraf.javautils.parsers.symbols.Symbol;

/**
 *  a ao responsvel por descartar o smbolo atual.
 */
public final class DiscardAction implements TransitionAction {
  /**
   * A instncia nica.
   */
  private static DiscardAction instance;

  /**
   * Obtm a instncia nica.
   * 
   * @return A instncia nica.
   */
  public static DiscardAction getInstance() {
    if (instance == null) {
      instance = new DiscardAction();
    }
    return instance;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void execute(final Symbol<?> symbol, final Session session) {
    if (symbol == null) {
      throw new IllegalArgumentException(
        "O smbolo que est sendo utilizado pelo autmato no pode ser nulo (null).");
    }
    if (session == null) {
      throw new IllegalArgumentException(
        "A sesso de execuo no pode ser nula (null).");
    }
  }

  /**
   * Construtor definido para impedir a criao de objetos desta classe
   * externamente.
   */
  private DiscardAction() {
  }
}
