package tecgraf.javautils.parsers.actions;

import tecgraf.javautils.parsers.Session;
import tecgraf.javautils.parsers.exception.AutomatonException;

/**
 * Representa uma ao a ser executada pelo autmato finito (
 * {@link tecgraf.javautils.parsers.FiniteAutomaton}) ao entrar ou sair de um estado (
 * {@link tecgraf.javautils.parsers.State}).
 */
public interface StateAction {
  /**
   * Executa a ao.
   * 
   * @param session A sesso de execuo do autmato.
   * @throws AutomatonException Caso ocorra algum erro durante a execuo da
   *         ao.
   */
  void execute(Session session) throws AutomatonException;
}
