/*
 * $Id: MalformedInputException.java 115073 2011-01-29 03:00:46Z clinio $
 */
package tecgraf.javautils.parsers.exception;

/**
 * Exceo de m formao no parser.
 * 
 * @author Tecgraf
 */
public class MalformedInputException extends Exception {
  /**
   * Num. da linha
   */
  private int lineNumber;

  /**
   * Construtor.
   * 
   * @param lineNumber linha
   * @param message mensagem
   */
  public MalformedInputException(int lineNumber, String message) {
    super(message);
    this.lineNumber = lineNumber;
  }

  /**
   * Construtor.
   * 
   * @param lineNumber linha
   * @param cause causa
   */
  public MalformedInputException(int lineNumber, Throwable cause) {
    super(cause);
    this.lineNumber = lineNumber;
  }

  /**
   * Construtor.
   * 
   * @param lineNumber linha
   * @param message mensagem
   * @param cause causa
   */
  public MalformedInputException(int lineNumber, String message, Throwable cause) {
    super(message, cause);
    this.lineNumber = lineNumber;
  }

  /**
   * Consulta o nmero da linha
   * 
   * @return alinha
   */
  public int getLineNumber() {
    return this.lineNumber;
  }
}
