/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.javautils.version;

import java.io.Serializable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class VersionNumber
implements Comparable<VersionNumber>,
Serializable {
    public static final int MAX_PART = 99;
    public static final VersionNumber ZERO_VERSION = new VersionNumber(0, 0, 0);
    public static final VersionNumber LIMIT_VERSION = new VersionNumber(99, 99, 99);
    private static final String TAG_FORMATTER = "v%01d_%02d_%02d";
    private static final String BRANCH_FORMATTER = "v%01d_%02d";
    private static final String TXT_FORMATTER = "%d.%d.%d";
    private static final String DRX = "\\d+{1,2}";
    private static final String GDRX = "(\\d+{1,2})";
    private static final String TAG_REGEX = String.format("v%s_%s_%s", "(\\d+{1,2})", "(\\d+{1,2})", "(\\d+{1,2})");
    private static final String BRANCH_REGEX = String.format("v%s_%s", "(\\d+{1,2})", "(\\d+{1,2})");
    private static final String TXT_REGEX = String.format("%s\\.%s\\.%s", "(\\d+{1,2})", "(\\d+{1,2})", "(\\d+{1,2})");
    static final Pattern TAG_PATT = Pattern.compile(TAG_REGEX);
    static final Pattern BRANCH_PATT = Pattern.compile(BRANCH_REGEX);
    static final Pattern TXT_PATT = Pattern.compile(TXT_REGEX);
    private static final int INVALID = -9999;
    private boolean isFrozen = false;
    private int major;
    private int minor;
    private int patch;

    public VersionNumber(int n, int n2, int n3) {
        this.major = n;
        this.minor = n2;
        this.patch = n3;
        this.check();
    }

    public static VersionNumber fromString(String string) {
        int[] nArray = new int[]{1, 2, 3};
        return VersionNumber.fromStringAsPattern(TXT_PATT, string, nArray);
    }

    public static VersionNumber fromStringAsBranch(String string) {
        int[] nArray = new int[]{1, 2, 1};
        VersionNumber versionNumber = VersionNumber.fromStringAsPattern(BRANCH_PATT, string, nArray);
        versionNumber.setPatch(0);
        return versionNumber;
    }

    private static VersionNumber fromStringAsPattern(Pattern pattern, String string, int[] nArray) {
        Matcher matcher = pattern.matcher(string);
        if (!matcher.matches()) {
            return null;
        }
        String string2 = matcher.group(nArray[0]);
        String string3 = matcher.group(nArray[1]);
        String string4 = matcher.group(nArray[2]);
        if (string2 == null || string3 == null || string4 == null) {
            return null;
        }
        try {
            int n = Integer.parseInt(string2);
            int n2 = Integer.parseInt(string3);
            int n3 = Integer.parseInt(string4);
            VersionNumber versionNumber = new VersionNumber(n, n2, n3);
            return versionNumber;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static VersionNumber fromStringAsTag(String string) {
        int[] nArray = new int[]{1, 2, 3};
        return VersionNumber.fromStringAsPattern(TAG_PATT, string, nArray);
    }

    public static boolean isValidPart(int n) {
        return n >= 0 && n <= 99;
    }

    public void add() {
        ++this.patch;
        if (this.patch <= 99) {
            return;
        }
        this.patch = 0;
        ++this.minor;
        if (this.minor <= 99) {
            return;
        }
        this.patch = 0;
        this.minor = 0;
        ++this.major;
        if (this.major > 99) {
            this.invalidate();
        }
    }

    public void check() {
        this.checkPart(this.major);
        this.checkPart(this.minor);
        this.checkPart(this.patch);
    }

    private void checkFrozen() {
        if (this.isFrozen) {
            throw new IllegalStateException("version data is frozen.");
        }
    }

    private void checkPart(int n) {
        if (n > 99 || n < 0) {
            String string = String.format("bad part version number: %s", n);
            throw new IllegalStateException(string);
        }
    }

    protected VersionNumber clone() {
        return new VersionNumber(this.major, this.minor, this.patch);
    }

    @Override
    public int compareTo(VersionNumber versionNumber) {
        if (versionNumber == null) {
            throw new IllegalArgumentException("null version for comparison");
        }
        if (this.major != versionNumber.major) {
            return this.major > versionNumber.major ? 1 : -1;
        }
        if (this.minor != versionNumber.minor) {
            return this.minor > versionNumber.minor ? 1 : -1;
        }
        if (this.patch != versionNumber.patch) {
            return this.patch > versionNumber.patch ? 1 : -1;
        }
        return 0;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        VersionNumber versionNumber = (VersionNumber)object;
        if (this.major != versionNumber.major) {
            return false;
        }
        if (this.minor != versionNumber.minor) {
            return false;
        }
        return this.patch == versionNumber.patch;
    }

    public void freeze() {
        this.isFrozen = true;
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public int getPatch() {
        return this.patch;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + this.major;
        n = 31 * n + this.minor;
        n = 31 * n + this.patch;
        return n;
    }

    public void increment(int n, int n2, int n3) {
        this.checkFrozen();
        this.setMajor(this.getMajor() + n);
        this.setMinor(this.getMinor() + n2);
        this.setPatch(this.getPatch() + n3);
    }

    public void invalidate() {
        this.checkFrozen();
        this.major = -9999;
        this.minor = -9999;
        this.patch = -9999;
    }

    public boolean isValid() {
        int n = this.getMajor();
        int n2 = this.getMinor();
        int n3 = this.getPatch();
        boolean bl = VersionNumber.isValidPart(n);
        boolean bl2 = VersionNumber.isValidPart(n2);
        boolean bl3 = VersionNumber.isValidPart(n3);
        return bl && bl2 && bl3;
    }

    public void setMajor(int n) {
        this.checkFrozen();
        this.checkPart(n);
        this.major = n;
    }

    public void setMinor(int n) {
        this.checkFrozen();
        this.checkPart(n);
        this.minor = n;
    }

    public void setPatch(int n) {
        this.checkFrozen();
        this.checkPart(n);
        this.patch = n;
    }

    public String toString() {
        return String.format(TXT_FORMATTER, this.major, this.minor, this.patch);
    }

    public final String toStringAsBranch() {
        String string = String.format(BRANCH_FORMATTER, this.major, this.minor);
        return string;
    }

    public String toStringAsTag() {
        return String.format(TAG_FORMATTER, this.major, this.minor, this.patch);
    }
}

