/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.javautils.xml;

import java.lang.reflect.Constructor;
import java.util.Map;
import tecgraf.javautils.xml.XMLElementFactoryInterface;
import tecgraf.javautils.xml.XMLElementInterface;
import tecgraf.javautils.xml.exception.XMLInternalErrorException;

public abstract class XMLElementFactory
implements XMLElementFactoryInterface {
    protected XMLElementFactory() {
        this.fillConversionTables();
    }

    @Override
    public XMLElementInterface createXMLElementFromTag(String tagName) {
        XMLElementInterface element = null;
        Class<? extends XMLElementInterface> xmlClass = null;
        Map<String, Class<? extends XMLElementInterface>> tagNamesToXMLClasses = this.getTagToXMLMap();
        try {
            xmlClass = tagNamesToXMLClasses.get(tagName);
            if (xmlClass != null) {
                element = xmlClass.newInstance();
                element.setAppContextObject(this.getAppContextObject());
                element.setTag(tagName);
            }
        }
        catch (IllegalAccessException e) {
            throw new XMLInternalErrorException(tagName, "construtor sem par\u00e2metros da classe " + xmlClass.getName() + " n\u00e3o est\u00e1 acess\u00edvel");
        }
        catch (InstantiationException e) {
            throw new XMLInternalErrorException(tagName, "classe " + xmlClass.getName() + " n\u00e3o possui construtor sem par\u00e2metros");
        }
        catch (Exception e) {
            throw new XMLInternalErrorException(tagName, e);
        }
        return element;
    }

    @Override
    public XMLElementInterface createXMLElementFromApp(Object appObject) {
        Class<?> appClass;
        XMLElementInterface element = null;
        if (appObject == null) {
            String err = "objeto nulo na criacao de elemento XML";
            throw new XMLInternalErrorException(null, "objeto nulo na criacao de elemento XML");
        }
        Map<String, Class<? extends XMLElementInterface>> tagNamesToXMLClasses = this.getTagToXMLMap();
        Map<Class<?>, String> appClassesToTags = this.getAppObjectToTagMap();
        String tagName = appClassesToTags.get(appClass = appObject.getClass());
        if (tagName == null) {
            String err = "tag nula para objeto da classe: " + appClass.getName();
            throw new XMLInternalErrorException(null, err);
        }
        Class<? extends XMLElementInterface> xmlClass = tagNamesToXMLClasses.get(tagName);
        if (xmlClass == null) {
            String err = "objeto nulo no mapeamento para a tag";
            throw new XMLInternalErrorException(tagName, "objeto nulo no mapeamento para a tag");
        }
        Constructor<? extends XMLElementInterface> xmlElementConstructor = null;
        Class[] noParams = new Class[]{};
        try {
            xmlElementConstructor = xmlClass.getConstructor(noParams);
        }
        catch (Exception e) {
            String err = "erro acessando construtor de " + xmlClass.toString();
            throw new XMLInternalErrorException(tagName, e, err);
        }
        Object[] noObjs = new Object[]{};
        try {
            element = xmlElementConstructor.newInstance(noObjs);
            element.setAppObject(appObject);
            element.setAppContextObject(this.getAppContextObject());
            element.setTag(tagName);
        }
        catch (Exception e) {
            String err = "erro executando construtor de " + xmlClass;
            throw new XMLInternalErrorException(tagName, e, err);
        }
        return element;
    }

    @Deprecated
    public final void mapTagToXMLClass(String tagName, String className) {
        if (className == null) {
            String err = "Nome de classe nulo em mapeamento TAG -> XML";
            throw new XMLInternalErrorException(tagName, "Nome de classe nulo em mapeamento TAG -> XML");
        }
        try {
            this.mapTagToXMLClass(tagName, Class.forName(className));
        }
        catch (ClassNotFoundException e1) {
            throw new XMLInternalErrorException(tagName, "Classe '" + className + "' inv\u00e1lida em mapeamento TAG -> XML");
        }
    }

    public final void mapTagToXMLClass(String tagName, Class<? extends XMLElementInterface> cls) {
        if (tagName == null) {
            String err = "Tag nulo em mapeamento TAG -> XML";
            throw new XMLInternalErrorException(null, "Tag nulo em mapeamento TAG -> XML");
        }
        if (cls == null) {
            String err = "Classe nula em mapeamento TAG -> XML";
            throw new XMLInternalErrorException(tagName, "Classe nula em mapeamento TAG -> XML");
        }
        Map<String, Class<? extends XMLElementInterface>> tagNamesToXMLClasses = this.getTagToXMLMap();
        if (tagNamesToXMLClasses.containsKey(tagName)) {
            if (tagNamesToXMLClasses.get(tagName) != cls) {
                throw new XMLInternalErrorException(tagName, "redefini\u00e7\u00e3o de mapeamento da tag");
            }
        } else {
            tagNamesToXMLClasses.put(tagName, cls);
        }
    }

    @Deprecated
    public final void mapAppClassToTag(String className, String tagName) {
        if (tagName == null) {
            throw new XMLInternalErrorException(null, "Tag nulo em mapeamento CLASS -> TAG");
        }
        if (className == null) {
            throw new XMLInternalErrorException(tagName, "Nome de classe nulo em mapeamento CLASS -> TAG");
        }
        Map<Class<?>, String> appClassesToTags = this.getAppObjectToTagMap();
        try {
            appClassesToTags.put(Class.forName(className), tagName);
        }
        catch (ClassNotFoundException e) {
            throw new XMLInternalErrorException(tagName, "Classe '" + className + "' inv\u00e1lida em mapeamento CLASS -> TAG");
        }
    }

    public final void mapAppClassToTag(Class<?> cls, String tagName) {
        if (tagName == null) {
            String err = "Tag nulo em mapeamento CLASS -> TAG";
            throw new XMLInternalErrorException(null, "Tag nulo em mapeamento CLASS -> TAG");
        }
        if (cls == null) {
            String err = "Classe nula em mapeamento CLASS -> TAG";
            throw new XMLInternalErrorException(tagName, "Classe nula em mapeamento CLASS -> TAG");
        }
        Map<Class<?>, String> appClassesToTags = this.getAppObjectToTagMap();
        if (appClassesToTags.containsKey(cls)) {
            if (!appClassesToTags.get(cls).equals(tagName)) {
                throw new XMLInternalErrorException(cls.getName(), "redefini\u00e7\u00e3o de mapeamento da classe");
            }
        } else {
            appClassesToTags.put(cls, tagName);
        }
    }

    protected abstract void fillConversionTables();

    protected abstract Map<String, Class<? extends XMLElementInterface>> getTagToXMLMap();

    protected abstract Map<Class<?>, String> getAppObjectToTagMap();
}

