/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.javautils.xml;

import java.io.Closeable;
import java.io.IOException;
import java.io.Reader;
import java.util.Map;
import tecgraf.javautils.xml.XMLBasicHandler;
import tecgraf.javautils.xml.XMLElementFactoryInterface;
import tecgraf.javautils.xml.XMLElementInterface;
import tecgraf.javautils.xml.XMLHandlerInterface;
import tecgraf.javautils.xml.XMLParser;

public class XMLReader
implements Closeable {
    private XMLParser parser;
    private XMLElementInterface xmlRoot;
    private String xmlFilePath;
    private String encoding;
    private Reader reader;
    private XMLHandlerInterface handler;
    private boolean alreadyRead;
    public static final String DEFAULT_ENCODING = "ISO-8859-1";

    private void setAppContext(Object appContext) {
        this.handler.getXMLFactory().setAppContextObject(appContext);
    }

    public final void read() throws IOException {
        if (this.alreadyRead) {
            throw new IllegalStateException("O arquivo j\u00e1 foi processado");
        }
        this.xmlRoot = this.parser.parse(this.reader);
        this.alreadyRead = true;
    }

    public final String getEncoding() {
        return this.encoding;
    }

    @Deprecated
    public final XMLElementFactoryInterface getXmlFactory() {
        return this.handler.getXMLFactory();
    }

    public final XMLElementFactoryInterface getXMLFactory() {
        return this.handler.getXMLFactory();
    }

    public final void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public final String getDTD() {
        return this.parser.getDTD();
    }

    public final XMLElementInterface getXMLRootObject() {
        return this.xmlRoot;
    }

    public final Object getAppRootObject() {
        return this.xmlRoot.getAppObject();
    }

    @Deprecated
    public final String getXmlFilePath() {
        return this.xmlFilePath;
    }

    public final String getXMLFilePath() {
        return this.xmlFilePath;
    }

    public XMLReader(Reader reader, Map<String, Class<? extends XMLElementInterface>> tagToObjMap, boolean validate) {
        this(reader, new XMLBasicHandler(tagToObjMap), validate);
    }

    public XMLReader(Reader reader, Class<? extends XMLElementInterface> cls, boolean validate) {
        this(reader, new XMLBasicHandler(cls), validate);
    }

    public XMLReader(Reader reader, XMLElementFactoryInterface factory, boolean validate) {
        this(reader, new XMLBasicHandler(factory), validate);
    }

    public XMLReader(Reader reader, XMLHandlerInterface handler, boolean validate) {
        this.reader = reader;
        this.handler = handler;
        this.parser = new XMLParser(handler, validate);
        this.alreadyRead = false;
    }

    public XMLReader(Reader reader, XMLHandlerInterface handler, boolean validate, Object appContext) {
        this(reader, handler, validate);
        this.setAppContext(appContext);
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }
}

