/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.javautils.xml;

import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Map;
import tecgraf.javautils.xml.XMLBasicElementFactory;
import tecgraf.javautils.xml.XMLElementFactoryInterface;
import tecgraf.javautils.xml.XMLElementInterface;
import tecgraf.javautils.xml.XMLUtils;
import tecgraf.javautils.xml.exception.XMLException;

public class XMLWriter
implements Closeable {
    private Writer writer;
    private Charset charset;
    private XMLElementInterface xmlRoot;
    private String dtd;
    public static final Charset DEFAULT_CHARSET = Charset.forName("ISO-8859-1");
    private static String DEFAULT_IDENT = "  ";
    private XMLElementFactoryInterface xmlFactory;

    private void doWrite() throws XMLException {
        if (this.xmlRoot == null) {
            throw new XMLException("Elemento <root> nulo na escrita XML!");
        }
        try {
            this.writeXMLHeader();
            this.xmlRoot.write(this.writer, "");
            this.writer.flush();
        }
        catch (IOException e) {
            throw new XMLException(e);
        }
    }

    private void writeXMLHeader() throws IOException {
        this.writer.write("<?xml version=\"1.0\" encoding=\"" + this.charset.name() + "\"?>\n");
        if (this.dtd != null) {
            this.writer.write("<!DOCTYPE " + this.xmlRoot.getTag() + " SYSTEM \"" + this.dtd + "\">\n\n");
        }
    }

    private void setappContext(Object appContext) {
        this.xmlFactory.setAppContextObject(appContext);
        this.xmlRoot.setAppContextObject(appContext);
    }

    public static String getDefaultIdent() {
        return DEFAULT_IDENT;
    }

    public final XMLElementFactoryInterface getXmlFactory() {
        return this.xmlFactory;
    }

    public final void setDefaultIdent(String ident) {
        DEFAULT_IDENT = ident;
    }

    public final void write() throws XMLException {
        this.writer = new BufferedWriter(new PrintWriter(System.out));
        this.doWrite();
    }

    public final void write(Writer w) {
        this.writer = w;
        this.doWrite();
    }

    public final void write(OutputStream stream) {
        this.write(new BufferedWriter(new OutputStreamWriter(stream, this.charset)));
    }

    public XMLWriter(Object rootObject, Map<Class<?>, String> objToTagMap, String dtd, Charset charset) throws XMLException {
        this(rootObject, (XMLElementFactoryInterface)new XMLBasicElementFactory(null, objToTagMap), dtd, charset);
    }

    public XMLWriter(Object rootObject, Map<Class<?>, String> objToTagMap, String dtd, String charset) throws XMLException {
        this(rootObject, (XMLElementFactoryInterface)new XMLBasicElementFactory(null, objToTagMap), dtd, charset);
    }

    public XMLWriter(Object rootObject, XMLElementFactoryInterface xmlFactory, String dtd, Charset charset) throws XMLException {
        if (rootObject == null) {
            throw new IllegalArgumentException("objeto da aplica\u00e7\u00e3o n\u00e3o pode ser nulo");
        }
        if (xmlFactory == null) {
            throw new IllegalArgumentException("f\u00e1brica XML n\u00e3o pode ser nula");
        }
        this.xmlFactory = xmlFactory;
        this.charset = charset;
        this.dtd = dtd;
        this.xmlRoot = xmlFactory.createXMLElementFromApp(rootObject);
        if (this.xmlRoot == null) {
            throw new XMLException("Elemento <root> retornado da f\u00e1brica nulo!");
        }
    }

    public XMLWriter(Object rootObject, XMLElementFactoryInterface xmlFactory, String dtd, String encoding) throws XMLException {
        this(rootObject, xmlFactory, dtd, Charset.forName(encoding));
    }

    public XMLWriter(Object rootObject, Object appContext, XMLElementFactoryInterface xmlFactory, String dtd, String encoding) throws XMLException {
        this(rootObject, xmlFactory, dtd, Charset.forName(encoding));
        this.setappContext(appContext);
    }

    public XMLWriter(Object rootObject, Object appContext, XMLElementFactoryInterface xmlFactory, String dtd, Charset charset) throws XMLException {
        this(rootObject, xmlFactory, dtd, charset);
        this.setappContext(appContext);
    }

    public XMLWriter(Object rootObject, XMLElementFactoryInterface xmlFactory, String dtd) {
        this(rootObject, xmlFactory, dtd, DEFAULT_CHARSET);
    }

    public XMLWriter(Object rootObject, Object appContext, XMLElementFactoryInterface xmlFactory, String dtd) {
        this(rootObject, xmlFactory, dtd, DEFAULT_CHARSET);
        this.setappContext(appContext);
    }

    public XMLWriter(Object rootObject, XMLElementFactoryInterface xmlFactory) {
        this(rootObject, xmlFactory, (String)null, DEFAULT_CHARSET);
    }

    public XMLWriter(Object rootObject, Object appContext, XMLElementFactoryInterface xmlFactory) {
        this(rootObject, xmlFactory);
        this.setappContext(appContext);
    }

    @Override
    public void close() throws IOException {
        XMLUtils.close(this.writer);
    }
}

