/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.javautils.xml.conversion;

import java.io.IOException;
import java.io.InputStream;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.ext.DefaultHandler2;
import tecgraf.javautils.xml.XMLUtils;

class ConversionBaseHandler
extends DefaultHandler2 {
    private String dtdPrefix;
    private final boolean fromJar;

    public ConversionBaseHandler(String dtdPrefix) {
        this(dtdPrefix, false);
    }

    public ConversionBaseHandler(String dtdPrefix, boolean fromJar) {
        this.fromJar = fromJar;
        this.dtdPrefix = dtdPrefix;
    }

    private static String removeLeadingSlash(String path) {
        if (path == null) {
            return null;
        }
        if (path.startsWith("/")) {
            return path.substring(1);
        }
        return path;
    }

    @Override
    public InputSource resolveEntity(String name, String publicId, String baseURI, String systemId) throws SAXException, IOException {
        if (this.fromJar) {
            InputStream inputStream;
            String dtd = ConversionBaseHandler.removeLeadingSlash(systemId);
            if (this.dtdPrefix == null) {
                inputStream = this.getClass().getResourceAsStream(dtd);
            } else {
                String dtdResource = this.dtdPrefix + '/' + dtd;
                inputStream = this.getClass().getResourceAsStream(dtdResource);
                if (inputStream == null) {
                    throw new IOException("resource inv\u00e1lido: " + dtdResource);
                }
            }
            return new InputSource(inputStream);
        }
        String fixedURL = XMLUtils.fixUrlPrefix(systemId, this.dtdPrefix);
        return new InputSource(fixedURL);
    }
}

