/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.javautils.xml.conversion.exception;

public class XMLConversionException
extends Exception {
    private XMLConversionExceptionType type;

    public XMLConversionException(XMLConversionExceptionType type) {
        this.type = type;
    }

    public XMLConversionException(XMLConversionExceptionType type, String details) {
        super(details);
        this.type = type;
    }

    public XMLConversionException(XMLConversionExceptionType type, Throwable original) {
        super(original);
        this.type = type;
    }

    public XMLConversionException(XMLConversionExceptionType type, String details, Throwable original) {
        super(details, original);
        this.type = type;
    }

    public XMLConversionExceptionType getType() {
        return this.type;
    }

    @Override
    public String toString() {
        StringBuilder msg = new StringBuilder("Erro na convers\u00e3o do XML: ");
        switch (this.type) {
            case BROKEN_CHAIN: {
                msg.append("cadeia de convers\u00f5es foi quebrada, um dos conversores falhou");
                break;
            }
            case CANT_CONVERT: {
                msg.append("documento incompat\u00edvel com esta convers\u00e3o");
                break;
            }
            case FILE_NOT_FOUND: {
                msg.append("arquivo n\u00e3o encontrado");
                break;
            }
            case NO_INPUT: {
                msg.append("n\u00e3o h\u00e1 dados de entrada");
                break;
            }
            case NO_VALUE: {
                msg.append("elemento n\u00e3o possui valor");
                break;
            }
            case NODE_TYPE: {
                msg.append("opera\u00e7\u00e3o incompat\u00edvel com o tipo do n\u00f3");
                break;
            }
            case NOT_NUMBER: {
                msg.append("valor do elemento n\u00e3o \u00e9 um double");
                break;
            }
            case PARSER: {
                msg.append("erro no processamento do documento XML");
                break;
            }
            case QUERY: {
                msg.append("query XPath mal-formada ou erro no processamento da mesma");
                break;
            }
            case WRITE: {
                msg.append("erro na grava\u00e7\u00e3o do XML");
                break;
            }
            case CONVERSIONS_NOT_APPLIED: {
                msg.append("convers\u00f5es n\u00e3o foram aplicadas");
                break;
            }
            case INVALID_DTD: {
                msg.append("DTD n\u00e3o pode ser tratado por nenhuma convers\u00e3o");
                break;
            }
            case NO_CONVERSIONS: {
                msg.append("n\u00e3o foi definida nenhuma convers\u00e3o");
                break;
            }
            case CANT_VALIDATE: {
                msg.append("resultado da convers\u00e3o n\u00e3o \u00e9 v\u00e1lido de acordo com o DTD");
                break;
            }
            case CANT_BACKUP: {
                msg.append("erro fazendo backup do arquivo original");
                break;
            }
            case UNSUPPORTED_CHARSET: {
                msg.append("charset n\u00e3o suportado");
                break;
            }
            default: {
                String err = "Tipo de exce\u00e7\u00e3o n\u00e3o tratada! " + this.type.name();
                throw new AssertionError((Object)err);
            }
        }
        String originalMsg = super.toString();
        if (!"".equals(originalMsg)) {
            msg.append("\nDados adicionais\n\n");
            msg.append(super.toString());
        }
        return msg.toString();
    }

    public static enum XMLConversionExceptionType {
        PARSER,
        QUERY,
        WRITE,
        CANT_CONVERT,
        NO_INPUT,
        NODE_TYPE,
        BROKEN_CHAIN,
        NO_VALUE,
        NOT_NUMBER,
        FILE_NOT_FOUND,
        NO_CONVERSIONS,
        INVALID_DTD,
        CONVERSIONS_NOT_APPLIED,
        CANT_VALIDATE,
        CANT_BACKUP,
        UNSUPPORTED_CHARSET;

    }
}

