/*
 * Decompiled with CFR 0.152.
 */
package busexplorer.desktop.dialog;

import busexplorer.Application;
import busexplorer.ApplicationIcons;
import busexplorer.BusExplorerLogin;
import busexplorer.exception.handling.ExceptionContext;
import busexplorer.exception.handling.ExceptionHandler;
import busexplorer.utils.BusAddress;
import busexplorer.utils.BusExplorerTask;
import busexplorer.utils.ConfigurationProperties;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import tecgraf.javautils.core.lng.LNG;
import tecgraf.javautils.gui.GBC;
import tecgraf.openbus.admin.BusAdmin;

public class LoginDialog
extends JDialog {
    private JComboBox comboBus;
    private JTextField fieldAddress;
    private JTextField fieldUser;
    private JTextField fieldDomain;
    private JPasswordField fieldPassword;
    private JButton buttonLogin;
    private BusExplorerLogin login;
    private BusAdmin admin;

    public LoginDialog(Window owner, BusAdmin admin) {
        super(owner, LNG.get("LoginDialog.title") + " - " + LNG.get("Application.title"), Dialog.ModalityType.APPLICATION_MODAL);
        this.admin = admin;
        this.buildDialog();
    }

    private void buildDialog() {
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                LoginDialog.this.getOwner().dispose();
                System.exit(0);
            }
        });
        this.buildLoginPane();
        this.setLocationRelativeTo(this.getOwner());
    }

    public BusExplorerLogin getLogin() {
        return this.login;
    }

    private void buildLoginPane() {
        JPanel loginPanel = new JPanel(new BorderLayout());
        loginPanel.setBorder(new EmptyBorder(6, 6, 6, 6));
        JPanel configPanel = new JPanel();
        GridBagLayout configLayout = new GridBagLayout();
        configLayout.columnWidths = new int[]{300};
        configPanel.setLayout(configLayout);
        TitledBorder configBorder = new TitledBorder(null, LNG.get("LoginDialog.config.label"));
        configPanel.setBorder(configBorder);
        Font FONT_LABEL = new Font("Dialog", 0, 12);
        EnableLoginListener enableLoginListener = new EnableLoginListener();
        SelectAllTextListener selectAllTextListener = new SelectAllTextListener();
        ConfigurationProperties configProps = new ConfigurationProperties();
        Vector<BusAddress> busVector = new Vector<BusAddress>();
        int i = 1;
        while (true) {
            String busPrefix = "bus" + i + ".";
            String description = configProps.getProperty(busPrefix + "description");
            String address = configProps.getProperty(busPrefix + "address");
            if (description == null || address == null) break;
            busVector.add(BusAddress.toAddress(description, address));
            ++i;
        }
        this.fieldAddress = new JTextField();
        if (!busVector.isEmpty()) {
            busVector.add(BusAddress.UNSPECIFIED_ADDRESS);
            JLabel labelBus = new JLabel(LNG.get("LoginDialog.bus.label"));
            labelBus.setFont(FONT_LABEL);
            configPanel.add((Component)labelBus, new GBC(0, 0).horizontal().insets(6, 6, 3, 6));
            this.comboBus = new JComboBox(busVector);
            this.comboBus.addItemListener(e -> {
                BusAddress selectedBus = (BusAddress)this.comboBus.getSelectedItem();
                this.updateAddress(selectedBus);
                if (selectedBus.getType().equals((Object)BusAddress.AddressType.Unspecified)) {
                    this.fieldAddress.setEnabled(true);
                    this.fieldAddress.requestFocus();
                } else {
                    this.fieldAddress.setEnabled(false);
                    this.fieldUser.requestFocus();
                }
            });
            configPanel.add((Component)this.comboBus, new GBC(0, 1).horizontal().insets(0, 6, 6, 9));
        }
        JLabel labelHost = new JLabel(LNG.get("LoginDialog.host.label"));
        labelHost.setFont(FONT_LABEL);
        configPanel.add((Component)labelHost, new GBC(0, 2).west().insets(6, 6, 3, 6));
        this.fieldAddress.setToolTipText(LNG.get("LoginDialog.host.help"));
        this.fieldAddress.addFocusListener(selectAllTextListener);
        this.fieldAddress.getDocument().addDocumentListener(enableLoginListener);
        this.fieldAddress.setFocusable(true);
        if (!busVector.isEmpty()) {
            this.fieldAddress.setEnabled(false);
        }
        configPanel.add((Component)this.fieldAddress, new GBC(0, 3).horizontal().insets(0, 6, 6, 9));
        JLabel labelUser = new JLabel(LNG.get("LoginDialog.user.label"));
        labelUser.setFont(FONT_LABEL);
        configPanel.add((Component)labelUser, new GBC(0, 4).west().insets(6, 6, 3, 6));
        this.fieldUser = new JTextField();
        this.fieldUser.setToolTipText(LNG.get("LoginDialog.user.help"));
        this.fieldUser.addFocusListener(selectAllTextListener);
        this.fieldUser.getDocument().addDocumentListener(enableLoginListener);
        this.fieldUser.setFocusable(true);
        configPanel.add((Component)this.fieldUser, new GBC(0, 5).horizontal().insets(0, 6, 6, 9));
        JLabel labelPassword = new JLabel(LNG.get("LoginDialog.password.label"));
        labelPassword.setFont(FONT_LABEL);
        configPanel.add((Component)labelPassword, new GBC(0, 6).west().insets(6, 6, 3, 6));
        this.fieldPassword = new JPasswordField();
        this.fieldPassword.setToolTipText(LNG.get("LoginDialog.password.help"));
        this.fieldPassword.addFocusListener(selectAllTextListener);
        this.fieldPassword.setFocusable(true);
        configPanel.add((Component)this.fieldPassword, new GBC(0, 7).horizontal().insets(0, 6, 6, 9));
        JLabel labelDomain = new JLabel(LNG.get("LoginDialog.domain.label"));
        labelDomain.setFont(FONT_LABEL);
        configPanel.add((Component)labelDomain, new GBC(0, 8).west().insets(6, 6, 3, 6));
        this.fieldDomain = new JTextField();
        this.fieldDomain.setToolTipText(LNG.get("LoginDialog.domain.help"));
        this.fieldDomain.addFocusListener(selectAllTextListener);
        this.fieldDomain.setFocusable(true);
        configPanel.add((Component)this.fieldDomain, new GBC(0, 9).horizontal().insets(0, 6, 6, 9));
        loginPanel.add((Component)configPanel, "Center");
        this.buttonLogin = new JButton(LNG.get("LoginDialog.confirm.button"));
        this.buttonLogin.setToolTipText(LNG.get("LoginDialog.confirm.help"));
        this.buttonLogin.addActionListener(new LoginAction());
        this.buttonLogin.setIcon(ApplicationIcons.ICON_LOGIN_16);
        this.buttonLogin.setEnabled(false);
        Box buttonsBox = Box.createHorizontalBox();
        buttonsBox.setBorder(new EmptyBorder(9, 3, 3, 3));
        buttonsBox.add(Box.createHorizontalGlue());
        buttonsBox.add(this.buttonLogin);
        loginPanel.add((Component)buttonsBox, "South");
        this.setContentPane(loginPanel);
        this.getRootPane().setDefaultButton(this.buttonLogin);
        this.pack();
        this.fillLoginForm();
    }

    private void fillLoginForm() {
        String propertyHost = System.getProperty("host");
        String propertyPort = System.getProperty("port");
        try {
            Integer.parseInt(propertyPort);
        }
        catch (NumberFormatException e) {
            propertyPort = null;
        }
        if (propertyHost == null && propertyPort == null) {
            if (this.comboBus != null) {
                this.updateAddress((BusAddress)this.comboBus.getSelectedItem());
                this.fieldUser.requestFocus();
            } else {
                this.fieldAddress.requestFocus();
            }
        } else {
            if (this.comboBus != null) {
                this.comboBus.setSelectedItem(BusAddress.UNSPECIFIED_ADDRESS);
            }
            this.fieldAddress.setText(propertyHost);
            if (propertyHost == null) {
                this.fieldAddress.requestFocus();
            } else {
                this.fieldUser.requestFocus();
            }
        }
    }

    private void updateAddress(BusAddress selectedBus) {
        switch (selectedBus.getType()) {
            case Address: {
                this.fieldAddress.setText(String.format("%s:%d", selectedBus.getHost(), selectedBus.getPort()));
                break;
            }
            case Reference: {
                this.fieldAddress.setText(selectedBus.getIOR());
                break;
            }
            case Unspecified: {
                this.fieldAddress.setText("");
            }
        }
    }

    private class EnableLoginListener
    implements DocumentListener {
        private EnableLoginListener() {
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.validate();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.validate();
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.validate();
        }

        private void validate() {
            String text = LoginDialog.this.fieldAddress.getText().trim();
            BusAddress address = BusAddress.toAddress(null, text);
            if (text.length() > 0 && !address.getType().equals((Object)BusAddress.AddressType.Unspecified) && LoginDialog.this.fieldUser.getText().trim().length() > 0) {
                LoginDialog.this.buttonLogin.setEnabled(true);
            } else {
                LoginDialog.this.buttonLogin.setEnabled(false);
            }
        }
    }

    private class LoginAction
    implements ActionListener {
        private LoginAction() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            BusExplorerTask<Object> task = new BusExplorerTask<Object>((ExceptionHandler)Application.exceptionHandler(), ExceptionContext.LoginByPassword){
                BusExplorerLogin theLogin;

                @Override
                protected void performTask() throws Exception {
                    BusAddress address;
                    if (LoginDialog.this.comboBus == null) {
                        address = BusAddress.toAddress(null, LoginDialog.this.fieldAddress.getText().trim());
                    } else {
                        address = (BusAddress)LoginDialog.this.comboBus.getSelectedItem();
                        if (address.getType().equals((Object)BusAddress.AddressType.Unspecified)) {
                            address = BusAddress.toAddress(null, LoginDialog.this.fieldAddress.getText().trim());
                        }
                    }
                    String entity = LoginDialog.this.fieldUser.getText().trim();
                    String password = new String(LoginDialog.this.fieldPassword.getPassword());
                    String domain = LoginDialog.this.fieldDomain.getText().trim();
                    this.theLogin = new BusExplorerLogin(LoginDialog.this.admin, entity, address);
                    BusExplorerLogin.doLogin(this.theLogin, password, domain);
                }

                @Override
                protected void afterTaskUI() {
                    if (this.getStatus()) {
                        LoginDialog.this.dispose();
                        LoginDialog.this.login = this.theLogin;
                    } else {
                        if (this.theLogin != null) {
                            this.theLogin.logout();
                        }
                        LoginDialog.this.fieldUser.requestFocus();
                    }
                }
            };
            task.execute(LoginDialog.this, LNG.get("LoginDialog.waiting.title"), LNG.get("LoginDialog.waiting.msg"));
        }
    }

    private class SelectAllTextListener
    extends FocusAdapter {
        private SelectAllTextListener() {
        }

        @Override
        public void focusGained(FocusEvent event) {
            ((JTextField)event.getComponent()).selectAll();
        }
    }
}

