/*
 * Decompiled with CFR 0.152.
 */
package reuse.modified.logistic.logic.common;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import reuse.modified.logistic.logic.common.Identifiable;

public class Code<T>
implements Serializable,
Comparable<Code<T>> {
    private static final long serialVersionUID = 7617061903509182552L;
    private final Object code;
    private final String trimmedString;

    public Code(Object code) {
        this.code = code;
        this.trimmedString = ("" + code).trim();
    }

    public Object getCode() {
        return this.code;
    }

    public Code<T> getObject() {
        return this;
    }

    public static <T extends Identifiable<T>> List<Code<T>> getCodeList(List<T> originalList) {
        ArrayList<Code<T>> codeList = new ArrayList<Code<T>>();
        for (Identifiable t : originalList) {
            codeList.add(t.getId());
        }
        return codeList;
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (!(other instanceof Code)) {
            return false;
        }
        Code that = (Code)other;
        if (that.code == null) {
            return this.code == null;
        }
        return this.trimmedString.equals(that.trimmedString);
    }

    public int hashCode() {
        return this.trimmedString.hashCode();
    }

    public String toString() {
        return this.trimmedString;
    }

    @Override
    public int compareTo(Code<T> other) {
        if (other == null) {
            return 1;
        }
        try {
            int thisInt = Integer.parseInt(this.trimmedString);
            int otherInt = Integer.parseInt(other.trimmedString);
            return thisInt < otherInt ? -1 : (thisInt == otherInt ? 0 : 1);
        }
        catch (NumberFormatException e) {
            return this.trimmedString.compareTo(other.trimmedString);
        }
    }

    public <E> Code<E> cast() {
        return this;
    }
}

