/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.openbus.core;

import java.util.Properties;

public enum OpenBusProperty {
    LEGACY_DISABLE("legacy.disable", "false"),
    ACCESS_KEY("access.key", null),
    BUS_CERTIFICATE("bus.certificate", null),
    CACHE_SIZE("cache.size", "30"),
    THREAD_NUMBER("thread.number", "10"),
    TIME_INTERVAL("time.interval", "1000"),
    TIME_UNIT("time.unit", "ms");

    private final String key;
    private final String defaultValue;

    private OpenBusProperty(String key, String value) {
        this.key = key;
        this.defaultValue = value;
    }

    public String getKey() {
        return this.key;
    }

    String getProperty(Properties props) {
        switch (this) {
            case LEGACY_DISABLE: {
                return props.getProperty(this.key, this.defaultValue);
            }
            case ACCESS_KEY: {
                return props.getProperty(this.key);
            }
            case CACHE_SIZE: {
                return props.getProperty(this.key, this.defaultValue);
            }
            case BUS_CERTIFICATE: {
                return props.getProperty(this.key);
            }
            case THREAD_NUMBER: {
                return props.getProperty(this.key, this.defaultValue);
            }
            case TIME_INTERVAL: {
                return props.getProperty(this.key, this.defaultValue);
            }
            case TIME_UNIT: {
                return props.getProperty(this.key, this.defaultValue);
            }
        }
        return null;
    }
}

