/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.openbus.core;

import java.util.concurrent.atomic.AtomicInteger;
import tecgraf.openbus.core.Credential;
import tecgraf.openbus.core.TicketsHistory;

abstract class Session {
    private final int session;
    protected final byte[] secret;

    Session(int session, byte[] secret) {
        this.session = session;
        this.secret = secret;
    }

    public int getSession() {
        return this.session;
    }

    public byte[] getSecret() {
        return this.secret;
    }

    static class ClientSideSession
    extends Session {
        private final AtomicInteger ticket = new AtomicInteger(-1);
        private final String entity;
        private final boolean legacy;

        public ClientSideSession(Credential.Reset reset, byte[] secret) {
            super(reset.session, secret);
            this.legacy = reset.legacy;
            this.entity = !this.legacy ? reset.entity : reset.target;
        }

        public int nextTicket() {
            return this.ticket.incrementAndGet();
        }

        public String getEntity() {
            return this.entity;
        }

        public boolean legacy() {
            return this.legacy;
        }
    }

    static class ServerSideSession
    extends Session {
        private final TicketsHistory ticket = new TicketsHistory();
        private final String caller;

        public ServerSideSession(int session, byte[] secret, String caller) {
            super(session, secret);
            this.caller = caller;
        }

        public boolean checkTicket(int id) {
            return this.ticket.check(id);
        }

        public String getCaller() {
            return this.caller;
        }
    }
}

