/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.openbus.core;

class TicketsHistory {
    private int base = 0;
    private int bits = 0;
    private int index = 0;
    private static final int DEFAULT_SIZE = 32;
    private final int size;

    public TicketsHistory() {
        this(32);
    }

    public TicketsHistory(int size) {
        this.size = size;
    }

    private boolean FLAG(int index) {
        return (this.bits & 1 << index) != 0;
    }

    private void SET(int index) {
        this.bits |= 1 << index;
    }

    private void CLEAR(int index) {
        this.bits &= ~(1 << index);
    }

    private void discardBase() {
        ++this.base;
        if (this.bits != 0) {
            for (int i = 0; i < this.size && this.FLAG(this.index); ++i) {
                this.CLEAR(this.index);
                this.index = (this.index + 1) % this.size;
                ++this.base;
            }
            this.index = (this.index + 1) % this.size;
        }
    }

    public synchronized boolean check(int id) {
        if (id < this.base) {
            return false;
        }
        if (id == this.base) {
            this.discardBase();
            return true;
        }
        int shift = id - this.base - 1;
        if (shift < this.size) {
            int idx = (this.index + shift) % this.size;
            if (this.FLAG(idx)) {
                return false;
            }
            this.SET(idx);
            return true;
        }
        int extra = shift - this.size;
        if (extra < this.size) {
            for (int i = 0; i < extra; ++i) {
                this.CLEAR(this.index);
                this.index = (this.index + 1) % this.size;
            }
        } else {
            this.bits = 0;
            this.index = 0;
        }
        this.base += extra;
        this.discardBase();
        return this.check(id);
    }
}

